/**
 * Bhanu Pratap Singh
 */
Ext.define('Academia.view.examinationcenters.evalresultlisting.ExamResultEventGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.examresulteventgrid',
    store: 'examinationcenters.evaluationgrouplisting.ExamResultEventStore',
    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    border: true,
    autoScroll: false,
    isGridConfigurable: true,
    enableColumnHide: false,   
    frame:false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.evaluationgrouplisting.ExamResultEventStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	 tbar: [],
    columns: [{
        header: getExaminationTranslation('DETAILED_SEQUENCE'),
        dataIndex: 'eventName',
        flex:.1,
        sortable:true
    },/*{
        header: getCommonTranslation('PLANNED_DATE'),
        dataIndex: 'planedOnDate',
        flex:.1,
        sortable:true,
        renderer: function(date) {
            return dateRender(date);
        }
    },*/{
        header: getExaminationTranslation('EVAL_SEQUENCE_WEIGHTAGE'),
        dataIndex: 'weightage',
        flex:.1,
        sortable:true
    }, {
        header: getExaminationTranslation('MAX_MARKS_GRADE'),
        dataIndex: 'maxMarks',
        flex:.1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!isNullOrEmpty(record.data.maxMarks)){
        		return record.data.maxMarks;
        	} else if(!isNullOrEmpty(record.data.maxGrade)){
        		return record.data.maxGrade
        	} else {
        		return '-'
        	}
        }
    }, {
        header: getExaminationTranslation('OBTAINED_MARKS'),
        dataIndex: 'finalMarks',
        flex:.1,
        sortable: true,
        renderer:function(value,meta,record){
        if(record.raw.attendanceStatus == false){
        return 'AB'
        }
        else{
	        	if(!isNullOrEmpty(record.data.finalMarks)){
	        		return record.data.finalMarks;
	        	}else {
	        		return '-'
	        	}
	        }
        }
    },{
        header: getExaminationTranslation('EFFECTIVE_MARKS'),
        dataIndex: 'effectiveMarks',
        flex:.1,
        sortable: true,
        renderer:function(value,meta,record){
        	if(!record.data.whetherSpecialGrade &&!isNullOrEmpty(record.data.effectiveMarks)){
        		return record.data.effectiveMarks;
        	} else if(!isNullOrEmpty(record.data.finalGrade)){
        		return record.data.finalGrade
        	} else { 
        		return '-'
        	}
        }
    }, {
        header: getExaminationTranslation('SECTION_RANK'),
        dataIndex: 'sectionRank',
        flex:.1,
        sortable: true
    }, {
        header: getExaminationTranslation('EVENT_RANK'),
        dataIndex: 'courseRank',
        flex:.1,
        sortable: true
    }, {
        header: getExaminationTranslation('STATUS'),
        dataIndex: 'status',
        flex:.1,
        sortable: true,
        renderer: function(val) {
        	if(!isNullOrEmpty(val) && (val == "Pass" || val == "PASS" || val == "Pass With Distinction" || val == "PASS WITH DISTINCTION")){
        		return "<sapn style='color:green'>"+getExaminationTranslation(val)+"</span>";
        	} else if(!isNullOrEmpty(val)){
        		return "<sapn style='color:red'>"+getExaminationTranslation(val)+"</span>";
        	}
            
        }
    }]
});