/**
 * @author sumit meena
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.EvalGroupQuickFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.evalgroupquickfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
    			xtype : 'customcombobox',
    			name : 'academicTerm',
    			itemId : 'academicTermId',
    			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
    			store :Ext.create('Academia.store.common.AcademicTermStore'),
    			valueField : 'id',
    			displayField : 'value',
    			forceSelection:true,
    			typeAhead:false,
    		 },{
			xtype: 'customcombobox',
			name:'evaluationGroupId',
			itemId:'evaluationGroupItemId',
			store:'examinationcenters.evalresultlisting.EvaluationGroup',
			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
			valueField: 'id',
			displayField: 'itemValue',
			queryParam:'evaluationGroupCode',
			minChars:2,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
    			xtype : 'customcombobox',
    			name : 'programDepartment',
    			itemId : 'programDepartment',
    			fieldLabel : getCommonTranslation('PROGRAM_DEPARTMENT'),
    			store :Ext.create('Academia.store.examinationcenters.evaluationgroup.evalGroupProgramDepartment'),
    			valueField : 'id',
    			displayField : 'value',
    			forceSelection:true,
    			typeAhead:false,
    		 }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
    			xtype : 'customcombobox',
    			name : 'programCategory',
    			itemId : 'programCategory',
    			fieldLabel : getCommonTranslation('PROGRAM_CATEGORY'),
    			store :Ext.create('Academia.store.examinationcenters.evaluationgroup.evalGroupProgramCategory'),
    			valueField : 'id',
    			displayField : 'value',
    			forceSelection:true,
    			typeAhead:false,
    		 },{
			xtype: 'customcombobox',
			name:'program',
			itemId:'programItemId',
			store:'examinationcenters.manageEvaluation.evaluationgroup.EGProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchItemId',
			store:'examinationcenters.manageEvaluation.evaluationgroup.EGBatchStore',
			valueField:'id',
			displayField: 'value',
			typeAhead:false,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled : true,
			fieldLabel:getExaminationTranslation('BATCH')
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			store:Ext.create('Academia.store.examinationcenters.evaluationgroup.evalGroupProgramPeriod'),
			itemId:'periodItemId',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			allowBlank:false,
			minChars:3,
			disabled : true,
			fieldLabel:getExaminationTranslation('PERIOD')
		},{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId: 'sectionItemId',
			store : 'coursetransaction.sectionmanagement.SectionMultiSelect',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			minChars:3,
			disabled:true,
			hidden:true,
			fieldLabel:getExaminationTranslation('SECTION')
		},{
			xtype: 'customcombobox',
			name: 'evaluationType',
			itemId:'evaluationTypeItemId',
			store:'examCenter.AssignSequence.EvaluationType',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			hidden:true,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE')
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'courseId',
			itemId:'courseItemId',
			store:'examinationcenters.evaluationgroup.EGCourseByBatchStore',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),

			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}


		},{
			xtype: 'customcombobox',
			name:'courseVariant',
			itemId:'courseVariant',
			store:Ext.create('Academia.store.examinationcenters.evaluationgroup.evalGroupCourseVarient'),
			fieldLabel: getCommonTranslation('COURSE_VARIANT_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			width: 536,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),

			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}


		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '38px!important',paddingTop:'30px!important'},  
		width:'100%',
		items: [{
			xtype: 'fieldcontainer', 
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
	        	  xtype : 'customcombobox',
	        	  name : 'evaluationPlanType',
	        	  itemId:'evaluationType_Id',
	        	  fieldLabel : getExaminationTranslation('EVALUATION_PLAN_TYPE'),
	        	  store : 'examCenter.AssignSequence.EvaluationType',
	        	  valueField : 'value',
	        	  displayField : 'value',
                  forceSelection:true,
	        	  allowBlank:false
	          },{
				xtype: 'customcombobox',
				name: 'evaluationStage',
				itemId:'evaluationStageItemId',
				store:'examinationcenters.CenterUseFor',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				disabled:false,
				fieldLabel:getExaminationTranslation('EVALUATION_STAGE')
			},{
				xtype : 'customcombobox',
				name : 'placementEvaluationStage',
				itemId:'placementEvaluationStageItemId',
				fieldLabel : getExaminationTranslation('EVALUATION_STAGE'),
				store : 'examinationcenters.evaluation.PlacementAcademyOthers',
				valueField : 'id',
				displayField : 'value',
				hidden:true,
				disabled:true
			},{
					xtype: 'customcombobox',
					name:'evaluationPlanId',
					itemId:'evalautionPlanNoItemId',
					store:Ext.create('Academia.store.examinationcenters.evaluationgroup.evalGroupPlan'),
					fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'name',
					minChars:2,
					typeAhead:false,
					disabled: true,
					allowBlank: false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
					xtype: 'customcombobox',
					name: 'centerType',
					itemId: 'centerType',
					store: 'program.programDetails.programBatches.assignExamCenter.ProgramCenterTypeStore',
					displayField: 'value',
					valueField: 'id',
					typeAhead: true,
					forceSelection:true,
					fieldLabel:getExaminationTranslation('CENTER_TYPE')
			},{
					xtype: 'customcombobox',
					name:'centerName',
					itemId:'centerName',
					store:Ext.create('Academia.store.examinationcenters.evaluationgroup.evalGroupExamCenter'),
					fieldLabel:getExaminationTranslation('CENTER_NAME'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'name',
					minChars:2,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					disabled: true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
				xtype: 'customcombobox',
				name: 'evaluationStatus',
				store:'examinationcenters.evaluationgroup.EvaluationStatus',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				fieldLabel:getExaminationTranslation('EVALUATION_GROUP_STATUS')
			},]
		 },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				name: 'evalGroupStartDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				itemId:'evalGroupStartDateItemId',
				editable:false,
				fieldLabel:getExaminationTranslation('EVALUATION_GROUP_START_DATE')
			},{
				xtype: 'datefield',
				name: 'evalGroupTillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				editable:false,
				itemId:'evalGroupTillDateItemId',
				fieldLabel:getExaminationTranslation('EVALUATION_GROUP_TILL_DATE')
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				name: 'evalGroupEventStartDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				itemId:'evalGroupEventStartDateItemId',
				editable:false,
				fieldLabel:getExaminationTranslation('EVALUATION_GROUP_EVENT_START_DATE')
			},{
				xtype: 'datefield',
				name: 'evalGroupEventTillDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				editable:false,
				itemId:'evalGroupEventTillDateItemId',
				fieldLabel:getExaminationTranslation('EVALUATION_GROUP_EVENT_TILL_DATE')
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items: [ {
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});