/**
 * sumit.meena
 */
var EvalGroupListingMasterGrid =Ext.create('Academia.store.examinationcenters.evaluationgrouplisting.EvalGroupListingMasterStore');
Ext.define('Academia.view.examinationcenters.evaluationgrouplisting.EvalGroupListingMasterGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.evalgrouplistingmastergrid',
    store: EvalGroupListingMasterGrid,
    title: getCommonTranslation('LIST_OF_APPLY_FOR_EVALUATION_GROUP'),
    border: true,
    frame:false,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
    isGridConfigurable:true,
    enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : EvalGroupListingMasterGrid,
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
	},
	 tbar: [{
	        xtype: 'button',
	        itemId: 'btnApply',
	        hidden:false,
	        text:getCommonTranslation('APPLY')
	       // disabled: true,
//	        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnMakePayment',
	        hidden:false,
	        text:getCommonTranslation('MAKE_PAYMENT'),
	        disabled: true
//	        tooltip: getCommonTranslation('ADD'),
//	        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    /*}, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'
	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH*/
	    },{	
			xtype : 'splitbutton',
	        itemId:'spBtnMoreActions',
	        text : getCommonTranslation('MOREACTIONS'),
	        menu:[{
	            text:getExaminationTranslation('APPROVE'),
	            itemId:'approveItemId'
	        },{
	            text:getExaminationTranslation('WITHDRAWN'),
	            itemId:'withdrawnItemId'
	        },{
	            text:getExaminationTranslation('GENERATE_HALL_TKT'),
	            itemId:'hallTicketGenerationItemId'
	        },{
	            text:getExaminationTranslation('PUBLISH_HALL_TICKET'),
	            itemId:'publishHallTicketItemId'
	        },{
	            text:getExaminationTranslation('PRINT_HALL_TICKET'),
	            itemId:'printHallTicketItemId',
	            hidden:true
	        },{
	            text:getExaminationTranslation('NOTIFY'),
	            itemId:'notifyItemId',
	            hidden:true
	        },{
	            text:getExaminationTranslation('DOWNLOAD_APPLICATION'),
	            itemId:'downloadApplicationItemId',
	            hidden:true
	        }, {
				itemId: 'downloadHallTicketBtnId',
				tooltip : getExaminationTranslation('DOWNLOAD_HALL_TICKETS'),
				text : getExaminationTranslation('DOWNLOAD_HALL_TICKETS'),
				disabled: true
			}, {
				itemId: 'downloadForm',
				tooltip : getExaminationTranslation('DOWNLOAD_FORM'),
				text : getExaminationTranslation('DOWNLOAD_FORM'),
				disabled: true
			}],
	        listeners: { click: function() { this.showMenu(); } }
	    },{
			xtype: 'button',
			itemId: 'evalGroupExportReport',
			tooltip : getCommonTranslation('EXPORTREPORTS'),
			text : getCommonTranslation('EXPORTREPORTS'),
			disabled: true,
			hidden:true
		}],
    columns: [{
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex:.4,
        sortable:true
    },{
        header: getCommonTranslation('STUDENT_CODE'),
        dataIndex: 'studentCode',
        flex:.4,
        sortable:true
    },{
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex:.4,
        sortable:true
    }, {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    }, {
        header: getCommonTranslation('EVALUATION_GROUP'),
        dataIndex: 'evaluationGroupCode',
        flex:.3,
        sortable: true
    }, /*{
        header: getExaminationTranslation('FEE_PLAN'),
        dataIndex: 'feePlanName',
        flex:.3,
        sortable: true
    },*/ {
        header: getCommonTranslation('AMOUNT'),
        dataIndex: 'newFeeAmount',
        flex:.3,
        sortable: true
    },{
        header: getCommonTranslation('LATE_FEE'),
        dataIndex: 'lateFeeAmount',
        flex:.3,
		renderer:function(value,meta,record){
        	if(record.data.lateFeeAmount==0.0){
        		return ' ';
        	} else {
        		return record.data.lateFeeAmount;
        	}
        }
    }, {
        header: getCommonTranslation('TOTAL_AMOUNT'),
        dataIndex: 'totalAmount',
        flex:.3,
        sortable: true
    }, {
    	/**
    	 * Hidden On discuss with pushpendra and rahul
    	 */
        header: getCommonTranslation('PAYMENT_MODE'),
        dataIndex: 'paymentMode',
        flex:.3,
        sortable: true,
        hidden:true
    }/*, {
        header: getExaminationTranslation('APPLICATION_REF'),
        dataIndex: '',
        flex:.3,
        sortable: true
    }*/, {
        header: getCommonTranslation('APPLICATION_STATUS'),
        dataIndex: 'applicationStatus',
        flex:.3,
        sortable: true,
        renderer: function(value){
        	if(!isNullOrEmpty(value)){
        		return capitaliseEnumValue(value);
        	} else {
        		return '';
        	}
        }
    }, {
        header: getCommonTranslation('HALL_TICKET_NO'),
        dataIndex: 'hallticket',
        flex:.3,
        sortable: true,
        renderer:function(value,meta,record){
        	if(value!=null) {
				return '<a href=#>'+value+'</a>';
        	}
		}
    },{
		header: getCommonTranslation('HALL_TICKET_PUBLISH'),
		dataIndex: 'isPublishHallTicket',
		flex:.3,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.financeHoldStatus) && (record.data.financeHoldStatus=="Hold" )){
				return '<sapn style=\'color:red\'>Hold for Student</span>';
			}else if(record.data.isPublishHallTicket){
				return '<sapn>Published</span>';
			}else{
				return '<sapn style=\'color:red\'>Pending</span>';
			}
		}
    },{
        header: getExaminationTranslation('CENTER_ALLOTED'),
        dataIndex: 'centerAllotted',
        flex:.3,
        sortable: true,
        renderer: function(value){
        	if(!isNullOrEmpty(value)){
        		return capitaliseEnumValue(value);
        	} else {
        		return '';
        	}
        }
    },{
        header: getCommonTranslation('FIRST_NAME'),
        dataIndex: 'firstName',
        flex:.4,
        sortable:true
    },{
        header: getCommonTranslation('MIDDLE_NAME'),
        dataIndex: 'middleName',
        flex:.4,
        sortable:true
    },{
        header: getCommonTranslation('LAST_NAME'),
        dataIndex: 'lastName',
        flex:.4,
        sortable:true
    }]
});