/**
 * @author sumit meena
 */
var EvalGroupListingPaymentGrid =Ext.create('Academia.store.examinationcenters.evaluationgrouplisting.payment.EvalGroupListingPayment');
Ext.define('Academia.view.examinationcenters.evaluationgrouplisting.payment.EvalGroupListingPaymentGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.evalgrouplistingpaymentgrid',
    store: EvalGroupListingPaymentGrid,
    border: true,
    autoScroll: false,
    frame:false,
    title:getExaminationTranslation('PAYMENT_LIST'),
   // selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : EvalGroupListingPaymentGrid,
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	 initComponent: function() {
	        var grid=this;                   
	        grid.addExportToolBarItems(grid);
	        this.callParent(arguments);     
	 },
	 tbar: [{
	        xtype: 'button',
	        name : 'makePaymentBtn',
	        itemId: 'makePaymentBtnItemId',
	        tooltip: getExaminationTranslation('COLLECT_PAYMENT'),
	        text:getExaminationTranslation('COLLECT_PAYMENT')
	    }],
    columns: [{
        header: getExaminationTranslation('BILL_NO'),
        dataIndex: 'billNo',
        flex:.4,
        sortable:true
    }, {
        header: getExaminationTranslation('FEE_PLAN'),
        dataIndex: 'feePlanName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('STAGE'),
        dataIndex: 'stageName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('AMOUNT'),
        dataIndex: 'newFeeAmount',
        flex:.3,
        sortable: true
  /*  }, {
        header: getExaminationTranslation('SEQUENCE'),
        dataIndex: 'feePlanSequence',
        flex:.3,
        sortable: true*/
    }, {
        header: getCommonTranslation('LATE_FEE'),
        dataIndex: 'newLateFee',
        flex:.3,
	    hidden:true,
		renderer:function(value,meta,record){
        	if(record.data.newLateFee==0.0){
        		return ' ';
        	} else {
        		return record.data.newLateFee;
        	}
        }

    }, {
        header: getCommonTranslation('TOTAL_AMOUNT'),
        dataIndex: 'totalAmount',
        flex:.3,
        sortable: true,
		hidden:true

    },{
        header: getExaminationTranslation('STATUS'),
        dataIndex: 'status',
        flex:.4,
        sortable:true,renderer:function(value,meta,record){
        	if(record.data.billNo==null){
        		return '<span style=\'color:red\'>Pending</span>';
        	} else {
        		return '<span style=\'color:green\'>Submitted</span>';
        	}
        }
    }]
});