/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationresult.EvaluationResultProgramFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.evaluationresultprogramfilter',
	autoScroll: false,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	cls:'customSearchInnerPanel',
	items:[{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			
				xtype: 'customcombobox',
	 			name:'programId',
	 			itemId:'programItemId',
	 			store:'examinationcenters.reports.ExaminationReportProgramStore',
	 			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
	 			displayField:'valueCode',
			    valueField:'id',
	 			queryParam:'name',
	 			minChars:3,
	 			//width: 536,
	 			typeAhead:false,
	 			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
	 			enableKeyEvents  : 'true',
	 			hideTrigger:false,
	 			forceSelection:true,
	 			allowBlank:false,
	 			//hidden:true,
	 			//disabled:true,
	 			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}  
			/*xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programItemId',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			store:'common.ProgramByAcademyLocationStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			allowBlank:false*/
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId: 'batchItemId',
			fieldLabel:getExaminationTranslation('BATCH'),
			store:'common.CurrentBatchStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			allowBlank:false
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			fieldLabel:getExaminationTranslation('PERIOD'),
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			allowBlank:false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'sectionId',
			itemId: 'sectionItemId',
			width: 536,
			fieldLabel: getExaminationTranslation('SECTION'),
			store:'attendance.SectionAndFacultyByPeriodID',
			displayField:'sectionCode',
			valueField:'sectionId',
			autoloadStore: false,
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			cls:'placementProgramMultiselect'
			
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'courseId',
			itemId: 'courseItemId',
			width: 536,
//			cls:'multiBrandCampusCls',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			store:'examinationcenters.evaluationresult.EvaluationResultCourseByPBS',
			displayField:'value',
			valueField:'code',/**its used to send course code to create dynamic columns*/ 
			autoloadStore: false,
			//forceSelection:true,
			//typeAhead:true,
			maxLength:10000,
		//	enforceMaxLength :true,
			allowBlank:false,
			readOnly:false,
			//disabled:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
				}
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});