/**
 * @author dharmendra.prajapati
 */
Ext.define('Academia.view.examinationcenters.evalution.coverageDetails.CoverageDetailsGrid', {
   // extend: 'Ext.grid.Panel',
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.evaluationcoveragedetailsgrid',
	store: 'examinationcenters.evaluation.coverageDetails.MappedCourseVariantGridStore',
    title : getExaminationTranslation('MAP_CV'),
    border: true,
    //autoScroll: true,
    frame:false,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
    	mode:'MULTI',
    	showHeaderCheckbox: true,
    	allowDeselect: false,
    	checkOnly : true
    },
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.evaluation.coverageDetails.MappedCourseVariantGridStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
    initComponent: function() {

        var grid=this;                   

        grid.addExportToolBarItems(grid);

        this.callParent(arguments);     

 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        tooltip: getExaminationTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
		 style:{
//				marginLeft:'5px',
				marginRight:'10px'
		}
	 },{	
		
		    	 xtype:'textfield',
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR') +' by '+ getExaminationTranslation('COURSE_CODE'),
				 width: 300,
				 name:'courseVarinat',
				 itemId:'courseVarinatId',
				 cls: 'SearchTextFieldWithSmallHeader',
		},{
			xtype: 'customcombobox',
			name: 'coverageAccountingYear',
			itemId: 'coverageAccountingYear',
			emptyText: getCommonTranslation('ACADEMIC_TERM'),
			store:Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			allowBlank:false,
			typeAhead:true,
			hidden:true,
			forceSelection:true
		},{
	        xtype: 'button',
	        itemId: 'btnReset',
	        tooltip: getExaminationTranslation('RESET'),
	        text:getExaminationTranslation('RESET')
    },{
		xtype : 'button',
		text:getExaminationTranslation('MARK_AS_COMPLETE'),
		tooltip: getExaminationTranslation('MARK_AS_COMPLETE'),
		itemId:'btnCompletedStatus'		
	},{
		xtype : 'button',
		itemId: 'btnPendingStatus',
		tooltip: getExaminationTranslation('MARK_AS_PENDING'),
		text:getExaminationTranslation('MARK_AS_PENDING'),
	}
    ],
    columns: [{
        header: getExaminationTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex:.1,
        sortable:true
    }, {
        header: getExaminationTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('PROGRAM_CODE_NAME'),
        dataIndex: 'programFullName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('SECTION'),
        dataIndex: 'sectionName',
        flex:.1,
        sortable:true
    }/*{
        header: getExaminationTranslation('PROGRAM_DETAILS'),
        dataIndex: 'sectionCount',
        flex:.1,
        renderer:function(value,meta,record){
        	if(value==0){
        		return value;
        	}
        	else {
				return '<a href=#>'+value+'</a>'
        	}
		}
    }*/,{
        header: getExaminationTranslation('EXAM_STATUS'),
        dataIndex: 'whetherExamCompleted',
        flex:.1,
        sortable:true,
        renderer:function(value,meta,record){
			if(value) {
				return "Completed";
			} else {
				return "Pending";
			}
        }
    }]
});