/**
 * Dharmendra.prajapati
 */
Ext.define('Academia.view.examinationcenters.evalution.coverageDetails.EvaluationCourseCoverage', {
    extend: 'Ext.window.Window',
    alias: 'widget.evaluationcoursecoverage',
	requires: ['Ext.ux.form.ItemSelector'],
    modal: true,
    overflowX: 'hidden',
    overflowY: 'auto',
    title: getExaminationTranslation('COURSE_MAPPING'),
    maxHeight:600,
    items: [{
        xtype: 'form',
        method: 'POST',
        //height:119,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        layout: 'anchor',
        defaults: {
        	  labelAlign: 'top',
        	  width: 256,
              anchor: '100%'
              
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{  
        	    xtype: 'hidden',
                name: 'idsToDelete'
            },{

            	xtype: 'multiselectcombofield',
        		name: 'courseCoverageId',
        		itemId:'courseCoverageItemId',
	  			fieldLabel: getExaminationTranslation('COURSE'),
        	    store:'attendance.CoursesByALandPlan',
        		displayField:'displayValue',
        		allowBlank:false,
	  			valueField:'id',
	  			width: 536,
	  			maxLength:1000000,
	  			maxSelection:1000000,
	  			minChars:3,
	  			//forceSelection:true,
	  			autoloadStore: false,
	  			maxHeight:200,
	  			queryParam:'courseName',
	  			typeAhead:true,
	  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,	
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width+50;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
	  			}
              },
              {
            	xtype: 'fieldcontainer',
                width:'100%',
                cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'submitBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cnclBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]

});