/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evalution.coverageDetails.ProgramBatchSectionCoverageGrid', {
  //  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.programbatchsectioncoveragegrid',
    store: 'examinationcenters.evaluation.coverageDetails.ProgramBatchSectionGrid',
    title: getExaminationTranslation('PROGRAM_BATCH_SECTION_LIST'),
    border: true,
    autoScroll: false,
    frame:false,
    viewConfig: {
        stripeRows: true
    },
    selType:'checkboxmodel',
    selModel: {
		checkOnly : true,
		allowDeselect: false
	},
    dockedItems: [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    	    xtype : 'custompagingtoolbar',
    	    plugins:['pagesize'],
    	    store : 'examinationcenters.evaluation.coverageDetails.ProgramBatchSectionGrid',
    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
    	    displayInfo : true
    	} ]
        }],
        initComponent: function() {
            var grid = this;

            // Configure scrollable content
            grid.scrollable = true;
            grid.height = 600; // Define height for the scrollable area

            // Add custom class for sticky header
            grid.cls = 'sticky-grid-header';
            grid.addExportToolBarItems(grid);
            this.callParent(arguments);    

     },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        /*xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {*/
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },{
    	xtype: 'button',
    	text: getCommonTranslation('SAVE'),
        tooltip: getCommonTranslation('SAVE'),
    	itemId: 'btnSave',
    	disabled: true,
    	scale: CONSTANTS.BUTTONSIZE
    }],
    columns: [{
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.2,
        sortable:true
    },{
        header: getExaminationTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocationName',
        flex:.2,
        sortable:true
    },{
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.2,
        sortable:true
    },{
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'programPeriodName',
        flex:.2,
        sortable:true
    }, {
        header: getExaminationTranslation('SECTION'),
        dataIndex: 'sectionCode',
        flex:.2,
        sortable: true
    }, {
    	header: getCommonTranslation('FACULTY_CODE_NAME'),
    	dataIndex: 'facultyId',
    	flex:.2,
    	sortable: true,
    	editor: {
    		xtype: 'customcombobox',
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyCombo',{
		        listeners: {
		        	beforeload: function(store, operation, options){
		            	store.proxy.extraParams.academyLocationIds = Academia.app.getAcademiaControllerBaseBaseControllerController().getCurrentAcademyLocation();
		            	store.proxy.extraParams.restrictToAL = true;
		            	store.proxy.extraParams.restrictToFacultyRole = true;
		            }
		        }
			}),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:false,
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: 'all',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},
		renderer: function(val,rec){
			if(!isNullOrEmpty(val) && isNullOrEmpty(rec.record.get('facultyCodeName'))){
				return rec.column.getEditor().store.findRecord('id',val).get('valueCode');
			}
			else{
				try{
					if(rec.column.getEditor().store.findRecord('id',val).get('valueCode')!=rec.record.get('facultyCodeName')){
						return rec.column.getEditor().store.findRecord('id',val).get('valueCode');
					}
				}
				catch(e){
					
				}
				if(isNullOrEmpty(rec.record.get('facultyCodeName'))){
					rec.tdCls = 'gridInputCustomStyle';
					return getCommonTranslation('PLACE_HOLDER_EMPTY_TEXT');
				}
				else{
					return rec.record.get('facultyCodeName');
				}
			}
		}
    }/*, {
        header: getExaminationTranslation('EVALUATION_PLAN_NO'),
        dataIndex: 'evaluationPlanNumber',
        flex:.2,
         sortable: true
     }, {
         header: getExaminationTranslation('EVALUATION_PLAN_STATUS'),
         dataIndex: 'completionStatus',
         flex:.2,
          sortable: true
      }*/],
      plugins: [{
    	  ptype : 'cellediting',
    	  clicksToEdit: 1,
    	  listeners: {
    		  beforeedit: function(ed,e){
    			  e.grid.getSelectionModel().deselectAll();
    			  setTimeout(function(){
    				  var facultyId = e.grid.getSelectionModel().getSelection()[0].get('facultyId');
    				  if(!isNullOrEmpty(facultyId)){
    					  e.column.getEditor().store.getProxy().extraParams.nameOrCode = '';
    					  e.column.getEditor().store.load({
    						  callback: function(){
    							  e.column.getEditor().setValue(facultyId);
    						  }
    					  });
    				  }
    			  },100);
    		  }
    	  }
      }],
      listeners:{
    	  beforeselect:function(selModel,record,index){
    		  if(!isNullOrEmpty(selModel.view.up())) {
    			  var grid = selModel.view.up();
    			  var gridItemId = grid.getItemId();
    			  try {
    				  var isViewOnly = Ext.ComponentQuery.query('contentPanel')[0].getActiveTab().down('evaluationplanbasicdetailform').isViewOnly;
    				  if(isViewOnly == true) {
    					  return false;
    				  }
    			  }
    			  catch(e) {
    				  //--
    			  }				   			
    		  }
    	  }
      }
});