/**
 * @Author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationDetail.EligibleProgramsTabFilter', { 
	extend : 'Ext.form.Panel',
	alias : 'widget.eligibleprogramstabfilter',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
	collapsed: true,
	collapsible: true,
	title: getCommonTranslation('SEARCH_FILTERS'),
	items : [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
		items :[{
			xtype: 'customcombobox',
			width: 536,
			name: 'academyLocation_EPFilter',
			itemId: 'academyLocation_EPFilter_ItemId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'examinationcenters.evaluation.coverageDetails.EvaluationPlanMappedALStore',
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			allowBlank:true,
			queryParam:'academyLocationName',
			minChars:3,
			typeAhead:false,
			labelAlign: 'top',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'programCategoryId_EPFilter',
			itemId:'programCategoryId_EPFilter_ItemId',
			store: 'program.ProgramCategoryByAlAndProgramStore',
			displayField: 'value',
			valueField: 'id',
			typeAhead:true,
			fieldLabel:getCommonTranslation('PROGRAM_CATEGORY'),
		}]
	},{
		xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items:[{
        	xtype: 'customcombobox',
        	name:'programId_EPFilter',
        	itemId:'programId_EPFilter_ItemId',
        	fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
        	store:'common.EligibleProgramListOtherEvalStore',
        	displayField:'value',
        	valueField:'id',
        	typeAhead:true,
        	forceSelection:true,
        	hideTrigger:false,
        	triggerAction: 'all',
        	minChars:3,
        	queryParam:'programName',
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{value}'  +
        			'</div>';
        		}
        	}
        },{
			xtype: 'customcombobox',
			name: 'batchId_EPFilter',
			itemId:'batchId_EPFilter_ItemId',
			store:'common.CurrentBatchStore',
			displayField:'value',
			valueField:'id',
			disabled:true,
			//forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('BATCH')
		},{
			xtype: 'customcombobox',
			name: 'periodId_EPFilter',
			itemId:'periodId_EPFilter_ItemId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			displayField:'value',
			valueField:'id',
			disabled:true,
			//forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('PERIOD')
		}]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'quickSearchId_EPFilter_ItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true,
            style: 'margin-left:0 !important;'
        },{
        	xtype: 'button',
			itemId: 'resetBtn_EPFilter_ItemId',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});