/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evalution.evaluationPlanHierarchy.StudentDetainGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
    alias: 'widget.studentdetaingrid',
    store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.DetainStudentList',
    border: true,
    autoScroll: false,
    //maxHeight: 700,
    frame:false,
    viewConfig: {
        stripeRows: false
    },
    selType:'checkboxmodel',
    selModel: {
    	mode:'MULTI',
    	showHeaderCheckbox: true,
    	allowDeselect: false,
    	checkOnly : true
    },
    style: {
		'position': 'relative !important'
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			// store: 'examinationcenters.evaluation.coverageDetails.CoverageDetailsGrid',
            store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.DetainStudentList',
        	emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
   },
    tbar:[
    	 {
        	xtype: 'button',
            text: getExaminationTranslation('PERMIT_STUDENT'),
            itemId: 'btnPermitSubmit',
            //ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }
    ],
    columns: [{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        flex:.4,
        hidden:true,
        sortable:true
    },{
		header: getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.3,
		sortable: true
	},{
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'studentAdmission',
        flex:.3,
        sortable: true
    },{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex:.3,
		sortable:true,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:.3,
		sortable:true,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex:.3,
		sortable:true,
		hidden :true
	}, {
        header: getExaminationTranslation('ATTENDANCE_PERCENTAGE'),
        dataIndex: 'attendancePercentage',
        flex:.3,
        sortable: true,
    	renderer:function(value,meta,record){
			return value+"%";
		}
    }, {
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PERIOD_ID'),
        dataIndex: 'periodId',
        flex:.3,
        hidden: true
    }, {
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex:.3,
        sortable: true
    }],
    plugins: [{
   	  ptype : 'cellediting',
   	  clicksToEdit: 1
     }]
});
