/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.examSpecialGrade.DownloadSpecialGradeFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.downloadspecialgradefilter',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		style:{
    		marginTop:'-2px !important',
    	},
		items: [{
    		xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTermItemId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			//store :Ext.create('Academia.store.common.AcademicTermStore'),
			store :Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			displayField : 'value',
			queryMode:'local',
			minChars:3,
			forceSelection:true,
			typeAhead:true,
			

	},{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programComboItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationReportProgramStore'),
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueSecondValue',
			queryParam:'name',
			minChars:3,
			width:475,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            width: 245,
            labelAlign: 'top'
        },
		items : [{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchComboItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.SpecialGradeBatchStore'),
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			disabled:true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodComboItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.SpecialGradePeriodStore'),
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			queryParam:'name',
			minChars:3,
			width:240,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseComboItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationReportCourseStore'),
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			autoloadStore: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{

		xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        itemId:'specialGradeFieldId',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
		items : [{
        	xtype: 'multiselectcombofield',
            name: 'courseVariant',
            itemId:'courseVariantComboItemId',
            store:Ext.create('Academia.store.attendance.VariantMappedToSpecialGrade'),
            displayField:'value',
            valueField:'id',
            cls:'commonAutoHeightMultiselectField',
            width:475,
			autoloadStore: false,
           
          //  maxLength:9999,
  		 //   maxSelections :9999,
            forceSelection:true,
            typeAhead:true,
            editable:false,
            allowBlank:false,
            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
        	listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
        	}
		},{
			xtype: 'customcombobox',
			name: 'specialGradeCombo',
			itemId: 'specialGradeComboId',
			editable:false,
			forceSelection:true,
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationSpecialGradeComboStore'),
            displayField:'value',
            valueField:'value',
            fieldLabel:getExaminationTranslation('SPECIAL_GRADE'),
			width: 256,
			allowBlank:false,
		}]
	
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype:'button',
			itemId:'specialGradeDownload',
			disabled:true,
			text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
			ui: 'CustomBtnSubmit',
			formBind:true
		}, 
		{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
