/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.examinationRemark.ExamRemarkFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.examremarkfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	modal: true,
	plugins:"formlabelrequired",
	standardSubmit: false,
	items: [{
		/*xtype: 'form',
        width: '100%',
        items: [{*/
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evaluationplantype',
			itemId:'evaluationplantypeItemId',
			store:'examCenter.AssignSequence.EvaluationType',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name:'evalautionPlanNo',
			itemId:'evalautionPlanNoItemId',
			store:'examinationcenters.evaluation.EvaluationPlanNo', //evaluationPlanType
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation("ENTER_THREE_CHAR"),
			listConfig: {
				loadingText: getCommonTranslation("SEARCHING"),
				emptyText: getCommonTranslation("NO_RECORDS_FOUND"),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			 xtype: 'customcombobox',
 			name:'courseId',
 			itemId:'course_Id',
 			store: 'attendance.CoursesByAcademyLocationIds',
 			fieldLabel: getCommonTranslation("COURSE"),
 			valueField: 'courseId',
 			displayField: 'courseCodeName',
 			queryParam:'name',
 			minChars:3,
 			typeAhead:false,
 			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
 			enableKeyEvents  : 'true',
 			hideTrigger:false,
 			forceSelection:true,
 			width: 256,
 			allowBlank:false,
 			emptyText: getCommonTranslation("ENTER_THREE_CHAR"),
 			listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation("SEARCHING"),
 				emptyText: getCommonTranslation("NO_RECORDS_FOUND"),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					'{courseId}' +
 					'</div>';
 				}
 			}
        }]
	},{
	    xtype: 'fieldcontainer',
        width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation("SEARCH"),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        }, {
            xtype: 'button',
            text: getCommonTranslation("RESET"),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        },{
        	xtype:'button',
        	itemId:'markEntryDownload',
        	hidden:true,
        	text:getExaminationTranslation('MARK_ENTRY_DOWNLOAD'),
        	ui: 'CustomBtnSubmit'
        },{
        	xtype:'button',
        	itemId:'markEntryUpload',
        	text:getExaminationTranslation('MARK_ENTRY_UPLOAD'),
        	ui : 'CustomBtnThird',
        	hidden:true
        }]
}]
});
