/**
 * @author Rohit Sharma
 */
var bulkExamResultPublishStore = Ext.create('Academia.store.examinationcenters.examresultpublish.BulkExamResultPublishGridStore');
Ext.define('Academia.view.examinationcenters.examresultpublish.BulkExamResultPublishGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.bulkExamResultPublishGrid',
    store: bulkExamResultPublishStore,
    title: getCommonTranslation('EXAMINATION_RESULT_PUBLISH'),
    border: true,
    refreshStoreData: true,
    selType: 'checkboxmodel',
    cls: 'bulk-exam-result-publish-grid',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
    	multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: bulkExamResultPublishStore,
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true,
            hidden: true
        }]
    }],
    isGridConfigurable: true,
    enableColumnHide: false,
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        text: getExaminationTranslation('PUBLISH_RESULT'),
        itemId: 'bulkPublishResultBtn',
        scale: CONSTANTS.BUTTONSIZE,
        tooltip: getExaminationTranslation('PUBLISH_RESULT'),
        disabled: true
    }, {
        xtype: 'button',
        text: getExaminationTranslation('UNPUBLISH_RESULT'),
        itemId: 'bulkUnpublishResultBtn',
        scale: CONSTANTS.BUTTONSIZE,
        tooltip: getExaminationTranslation('UNPUBLISH_RESULT'),
        disabled: true
    }],
    columns: [{
        header: getCommonTranslation('ADMISSION_CODE'),
        dataIndex: 'admissionCode',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: 1
    }, {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1.3,
        hidden: true
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('SECTION'),
        dataIndex: 'sectionName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantName',
        flex: 1.5
    }, {
        header: getCommonTranslation('EVALUATION_PLAN_NUMBER'),
        dataIndex: 'evaluationPlanName',
        flex: 1
    }, {
        header: getCommonTranslation('EVALUATION_TYPE'),
        dataIndex: 'evaluationTypeName',
        flex: 0.9
    }, {
        header: getCommonTranslation('EVALUATION_SUB_TYPE'),
        dataIndex: 'evaluationSubTypeName',
        flex: 1
    }, {
        header: getCommonTranslation('EVALUATION_METHOD'),
        dataIndex: 'evaluationMethodName',
        flex: 1
    }, {
        header: getCommonTranslation('EVENT_NAME'),
        dataIndex: 'evaluationEventName',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('MARKS_OBTAIN'),
        dataIndex: 'marksObtained',
        flex: 0.6,
        renderer: function (value, meta, record) {
            if (!isNullOrEmpty(record.data.absentDashStatus) && (record.data.absentDashStatus == "ABSENT" || record.data.absentDashStatus == "Absent")) {
                return "Absent";
            } else {
                return value;
            }
        }
    }, {
        header: getCommonTranslation('GRADE_OBTAINED'),
        dataIndex: 'grade',
        flex: 0.6
    }, {
        header: getCommonTranslation('RESULT_PUBLISH_STATUS'),
        dataIndex: 'resultPublishStatus',
        flex: 0.8,
        renderer: function (value, meta, record) {
            if (record.get('whetherResultPublishHold') && !isNullOrEmpty(value) && value) {
                return "Published with Hold";
            }
            if (!isNullOrEmpty(value) && value)
                return "Published";
            else if (!isNullOrEmpty(value) && !value) {
                return "Not Published";
            } else {
                return "Not Published";
            }
        }
    }, {
        header: getCommonTranslation('RESULT_PUBLISHED_BY'),
        dataIndex: 'resultPublishBy',
        flex: 1,
        hidden: true,
        renderer: function (value, meta, record) {
            if (!isNullOrEmpty(value))
                return getExaminationTranslation(value);
            else
                return '';
        }
    }, {
        header: getCommonTranslation('PUBLISH_DATE'),
        dataIndex: 'resultPublishDate',
        flex: 1,
        hidden: true,
        renderer: function (date) {
            return dateRender(date);
        }
    }]
});