/**
 * @author bhanu pratap singh
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.generatereportwin',
	title:getExaminationTranslation('GENERATE_REPORT'),
	modal: true,
//	autoScroll:true,
	maxHeight:500,
	width: '40%',
	height:'20%',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'vbox'
			},
			items: [{
				xtype: 'fieldcontainer',
				layout: {
					type: 'hbox',
					width: 536
				},
				items:[{
					xtype : 'radiogroup',
					itemId:'reportType',
					width: 536,
					defaults: {
						flex: .1
					},
					items : [{
						boxLabel : getExaminationTranslation('ABSENTEE_REPORT'),
						name : 'reportTypeId',
						inputValue : true,
						checked : true

					},{
						boxLabel : getExaminationTranslation('ATTENDANCE_SHEET'),
						name : 'reportTypeId',
						inputValue : false
					}]
				}]
			},{
			xtype: 'fieldcontainer',
				layout: {
					type: 'hbox'
				},
				items: [{
				xtype: 'customcombobox',
				name: 'evaluationGroupId',
				itemId: 'evaluationGroupItemId',
				store:'examinationcenters.evalresultlisting.EvaluationGroup',
				displayField:'code',
				valueField:'id',
				forceSelection:true,
				width: 408,
				typeAhead:true,
				fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
			}]
		},{
				xtype: 'fieldcontainer',    
				layout : {
					type : 'hbox'
				},
				items:[{
					xtype: 'customcombobox',
					itemId:'chooseTemplate',
					name: 'chooseTemplateId',
					store:'setup.templatemapping.TemplateNameForReport',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
					displayField:'code',
					valueField:'id',
					width:310,    
					forceSelection:true,
					typeAhead:true,
					minChars:3,
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						}
					},
					allowBlank:false,
					fieldLabel:getExaminationTranslation('TEMPLATE')
				},{
					xtype: 'button',
					text:'Preview Template',
					itemId: 'previewTemplateBtn',
					buttonAlign: 'bottom',
					ui: 'CustomBtnThird',
					scale: CONSTANTS.BUTTONSIZE,
					//hidden:true
					formBind:true
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
				width: 536
			},
			items:[{
				xtype : 'radiogroup',
				itemId:'studentTypeId',
				width: 536,
				hidden:true,
//				"SORT_REPORT_DATA_BY":"Sort Report Data By"
				fieldLabel: getExaminationTranslation('SORT_REPORT_DATA_BY'), 
				defaults: {
					flex: .1
				},
				items : [{
					boxLabel : getExaminationTranslation('REGULAR'),
					name : 'studentType',
					inputValue : getExaminationTranslation('REGULAR'),
					checked : true
				},{
					boxLabel : getExaminationTranslation('EX'),
					name : 'studentType',
					inputValue : getExaminationTranslation('EX')
				}]
			}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getServiceRequestTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE,
				listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
				}
			}]
		}]
	}]
});