/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateTabulationReportEGWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.generatetabulationreportegwin',
	title:getExaminationTranslation('GENERATE_REPORT'),
	modal: true,
//	autoScroll:true,
	maxHeight:500,
	width: 580,
	height:300,
	autoScroll:true,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
        		
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
	        	xtype: 'customcombobox',
	            name: 'studentType', 
	            itemId:'studentTypeId',
	            store: 'examinationcenters.evaluationgroup.StudentResultStatusEnumStore',
	            displayField: 'value',
	            valueField: 'id',
	            typeAhead: true,
	            allowBlank:false,
	            fieldLabel:getExaminationTranslation('STUDENT_TYPE'),
	            hidden:false
            },{
	        	xtype: 'customcombobox',
	            name: 'evaluationGroupId',
	            itemId: 'evaluationGroupItemId',
	            store:'examinationcenters.evalresultlisting.EvaluationGroupByProgBatch',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
//	            disabled : true,
	            fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
	          //  allowBlank:true
	        }]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			width:'auto',
			items : [{
            	xtype: 'customcombobox',
            	itemId:'chooseTemplate',
        		name: 'chooseTemplateId',
        	    store:'setup.templatemapping.TemplateNameForFoilsReportStore',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'displayValue',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('TEMPLATE')
            },{
    	        xtype: 'fieldcontainer',
            	layout: 'hbox',
            	style: {
            		marginTop:'25px'
            	},
            	items:[{
            		xtype: 'button',
        			text:'Preview Template',
        			itemId: 'previewTemplateBtn',
        			buttonAlign: 'bottom',
        			ui: 'CustomBtnThird',
        			scale: CONSTANTS.BUTTONSIZE,
        			//hidden:true
        			//formBind:true
            	}]
    		}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			width:'auto',
			items : [{
            	xtype: 'customcombobox',
            	itemId:'courseId',
        		name: 'courseId',
        	    store:'examinationcenters.reports.CourseByPeriodId',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'value',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		fieldLabel:getExaminationTranslation('COURSE'),
                labelSeparator:'',
				hidden:true
            },]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			style:{
			marginTop:'10px !important'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("SAVE_AND_GENRATE") ,
				itemId : 'submitandGenrateBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},
			
			{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
                }
            }]
		}]
	}]
});