/**
 * sumit.meena
 */

Ext.define('Academia.view.examinationcenters.manageEvaluation.FacultyMangeEvalResultMasterGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.facultymangeevalresultmastergrid',
	store: 'examinationcenters.manageEvaluation.ManageResultMasterStore',
	border: true,
	removeSerialColumn:true, // V2D-399821
	frame:false,
	selType:'checkboxmodel',
	headerFix: {
    	headerFix: true,
    	portalIdsWithStructure: {
			'personinfofacultyportal':2 
		}
    },
	title:getExaminationTranslation('MARK_ENTRY_LIST'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	style:{
		"margin-bottom":"30px !important"
	},
	selModel: {
		showHeaderCheckbox: true,
		checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false,
		//injectCheckbox:1
	},
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
		        itemId:'managePaggingToolBarItemId',
	            plugins:['pagesize'],
			    store : 'examinationcenters.manageEvaluation.ManageResultMasterStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],*/
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		/* xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {*/
		/*}, {
        xtype: 'button',
        itemId: 'btnApprove',
        tooltip: getExaminationTranslation('APPROVED'),
        text:getExaminationTranslation('APPROVED')
    }, {
        xtype: 'button',
        itemId: 'btnSentForApprove',
        tooltip: getExaminationTranslation('SENT_FOR_APPROVAL'),
        text:getExaminationTranslation('SENT_FOR_APPROVAL')*/
	},{
		xtype: 'button',
		itemId: 'btnEditNew',
		//text: 'New Edit Btn',
		tooltip: getCommonTranslation('EDIT')+'.',
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		text: getExaminationTranslation('SUBMIT'),
		itemId: 'submitBtnNew',
		disabled:true,
		hidden:true
	}, {
			xtype: 'button',
			itemId: 'facultyBtnMarkAttendance',
			/*ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,*/
			text:getExaminationTranslation('MARK_ATTENDANCE'),
			tooltip: getExaminationTranslation('MARK_ATTENDANCE')
		},{
			xtype: 'button',
			itemId: 'btnPublishMarksGrade',
			/*ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,*/
			text:getExaminationTranslation('PUBLISH_MARKS_GRADE'),
			tooltip: getExaminationTranslation('PUBLISH_MARKS_GRADE')
		}, {
	        xtype: 'button',
	        itemId: 'btnUnPublishMarksGrade',
	        text:getExaminationTranslation('UNPUBLISH_MARKS_GRADE'),
	        tooltip: getExaminationTranslation('UNPUBLISH_MARKS_GRADE'),
	        disabled: true
	    }, {
		xtype: 'button',
		text:getExaminationTranslation('APPROVE'),
		itemId:'btnApprove',
		hidden:true,
		tooltip: getExaminationTranslation('APPROVE')
	},{
		xtype: 'button',
		text:getExaminationTranslation('PRINT_BARCODE'),
		itemId:'btnPrintBarCode',
		tooltip: getExaminationTranslation('PRINT_BARCODE')
	}, {
	    xtype: 'button',
	    itemId: 'checkHistoryBtnFP',
	    tooltip: getExaminationTranslation('CHECK_HISTORY'),
	    text: getExaminationTranslation('CHECK_HISTORY'),
	    disabled: true
	}],
	columns: [{
		header: getExaminationTranslation('S_NO'),
		xtype: 'rownumberer',
		sortable: false,
		align:'center',
		flex:.1,
		dataIndex:'rownumberer',
		locked: false
	},{
		header: getExaminationTranslation('UNIQUE_CODE'),
		dataIndex: 'examUniqueCode',
		flex:.4,
		sortable:true,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.examUniqueCode)){
				return value;
			} else {
				return '<span style=\'color:red\'>N/A</span>'
			}
		}
	},{
		header: getExaminationTranslation('HALL_TICKET_NO'),
		dataIndex: 'hallticket',
		flex:.4,
		sortable:true,
		hidden:true,
		renderer:function(value,meta,record){
			if(isNullOrEmpty(record.get('fromTransferSectionId'))){
				meta.tdCls = 'blackCell';
			}
			return value;
		}
	},{
		header: getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.4,
		sortable:true
	},{
		header: getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentId',
		flex:.3,
		sortable: true,
		hidden:false
	},{
		header: getExaminationTranslation('NATIONAL_ID'),
		dataIndex: 'nationalID',
		flex:.3,
		sortable: true,
		hidden:true,
		renderer:function(value,meta,record){
			if(isNullOrEmpty(record.get('fromTransferSectionId'))){
				meta.tdCls = 'blackCell';
			}
			return value;
		}
	}, {
		header: getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.4,
		sortable: true
	},{
		header: getExaminationTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		flex:.3,
		hidden: true
	},{
		header: getExaminationTranslation('MIDDLE_NAME'),
		dataIndex: 'middleName',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.2,
		sortable: true
	},{
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('COURSE'),
		dataIndex: 'courseName',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantCode',
		flex:.3,
		sortable: true,
		hidden: true
	},{
		header: getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.4,
		sortable: true
	}/*,{
        header: getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseVariantCode',
        flex:.3,
        sortable: true
    }*/,{
    	header: getExaminationTranslation('ATTENDANCE_STATUS'),
    	dataIndex: 'whetherExamAttended',
    	flex:.3,
    	sortable: true,
    	renderer:function(value){
    		if(value){
    			return getExaminationTranslation('PRESENT');
    		}else {
    			return getExaminationTranslation('ABSENT');
    		}
    	}
    }, {
    	header: getExaminationTranslation('MAL_PRACTICE_STATUS'),
    	dataIndex: 'whetherMalpracticeReported',
    	flex:.3,
    	sortable: true,
    	hidden:true,
    	renderer:function(value){
    		if(value){
    			return getCommonTranslation('YES');
    		}else {
    			return getCommonTranslation('NO');
    		}
    	}
    }, {
    	header: getExaminationTranslation('TOTAL_MARKS'),
    	dataIndex: 'finalMarks',
    	flex:.2,
    	sortable: true,
    	renderer:function(value,meta,record){
    		if((!isNullOrEmpty(record.data.finalMarks) && record.data.finalMarks>0) && record.data.whetherQPApplicable){ 
    			return '<a href=#>'+record.data.finalMarks+'</a>';
    		} else if(!isNullOrEmpty(record.data.finalMarks)){ 
    			return record.data.finalMarks;
    		}
    	}
    }, {
    	header: getExaminationTranslation('FINAL_GRADE'),
    	dataIndex: 'finalGrade',
    	flex:.3,
    	sortable: true,
    	hidden:true
    },{
    	header: getExaminationTranslation('EFFECTIVE_MARKS'),
    	dataIndex: 'effectiveMarks',
    	flex:.3,
    	sortable: true,
    	renderer:function(value,meta,record){
    		if((!isNullOrEmpty(record.data.effectiveMarks) && record.data.effectiveMarks>0) && record.data.whetherQPApplicable){
    			return '<a href=#>'+record.data.effectiveMarks+'</a>';
    		} else if(!isNullOrEmpty(record.data.effectiveMarks)){ 
    			return record.data.effectiveMarks;
    		}
    	}
    },{
    	header: getExaminationTranslation('PENALTY_MARKS'),
    	dataIndex: 'penultyMarksGiven',
    	flex:.3,
    	hidden:true,
    	sortable: true,
    	renderer:function(value,meta,record){
    		if(!isNullOrEmpty(record.data.penultyMarksGiven)){
    			return Math.round(value * 100) / 100;
    		} else {
//  			return '<span style=\'color:red\'>N/A</span>'
    			return "N/A";
    		}
    	}
    },{
    	header: getExaminationTranslation('GRACE_MARKS'),
    	dataIndex: 'graceMarksGiven',
    	flex:.3,
    	hidden:true,
    	sortable: true,
    	renderer:function(value,meta,record){
    		if(!isNullOrEmpty(record.data.graceMarksGiven)){
    			return Math.round(value * 100) / 100;
    		} else {
//  			return '<span style=\'color:red\'>N/A</span>'
    			return "N/A";
    		}
    	}
    }, /*{
        header: getExaminationTranslation('PASS_FAIL'),
        dataIndex: 'status',
        flex:.3,
        sortable: true,
        renderer:function(value){
        	if(value){
        		return getExaminationTranslation(value);
        	}else {
        		return value;
        	}
        }
    },*/{
    	header: getExaminationTranslation('MARKS_SUBMISSION_STATUS'),
    	dataIndex: 'examResultStatus',
    	flex:.2,
    	sortable: true,
    	renderer:function(value,meta,record){
    		if(record.data.examResultStatus == 'RESULT_ENTERED'|| record.data.whetherExamAttended==false){  
    			return "<span style = 'color:green'>Done</span>";
    		} else {
    			return "<span style = 'color:red'>Pending</span>";
    		}
    	}
    },{
    	header: getExaminationTranslation('MARK_GRADE_PUBLISH_STATUS'),
    	dataIndex: 'resultPublishMode',
    	flex:.3,
    	sortable: true,
    	renderer:function(value,meta,record){
    		if(isNullOrEmpty(record.data.whetherPublish)){
    			return "Not Published";
    		} else if(record.data.whetherPublish){
    			return "Published";
    		}else if((!isNullOrEmpty(record.data.resultPublishMode) &&
    				record.data.resultPublishMode=="AUTO_PUBLISH") && 
    				!isNullOrEmpty(record.data.examResultStatus) && record.data.whetherPublish){
    			return "Published";
    		} else {
    			return "Not Published";;
    		}
    	}
    },{
    	header: getExaminationTranslation('INTERNAL_REMARK'),
    	dataIndex: 'finalDescription',
    	flex:.4,
    	sortable: true
    }],
    listeners : {
    	select: function (obj, record,rowIndex, e) {
    		var addButton=obj.view.ownerCt.down('#btnAdd');
    		/**
    		 * this  condition is for absent student can't entered mark entered 
    		 */
    		/*if(!record.data.whetherExamAttended){
        		obj.deselect(record);
  	    	  showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('ABESNT_STUDENT_CANT_SELECT'));
        	}*//*else{
        	 *//**
        	 * This condition is for examiner , examiner have only add functionality.  
        	 *//*
            	if(!addButton.isHidden()){
            		if(record.data.examResultStatus==getExaminationTranslation('CNTRL_RESULT_ENTERED')){
            	    	  obj.deselect(record);
            	    	  showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('RESULT_ALREADY_BEEN_ENTERED'));
            	       }          		
            	}
        	}*/
    	}
    }
});