/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.manageEvaluation.ImportMarksRemarksFilter', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.importMarksRemarksFilter',
    margin: '-16 10 8 0',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins: "formlabelrequired",
    cls:'customSearchInnerPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'assessmentSchemeType',
            itemId: 'importMarksRemarksEvaluationTypeItemId',
            store: Ext.create('Academia.store.examCenter.AssignSequence.EvaluationType'),
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            typeAhead: true,
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_TYPE'),
            allowBlank: false
        }, {
			xtype: 'customcombobox',
			name:'evaluationStage',
			store:'examinationcenters.CenterUseFor',
			itemId:'evaluationStageItemId',
			fieldLabel: getExaminationTranslation('EVALUATION_STAGE'),
			displayField: 'value',
			valueField: 'id',
			typeAhead: true,
			forceSelection: true,
			hidden: true
		}, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            name: 'academicTermId',
            itemId: 'importMarksRemarksAcademicTermId',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            minChars: 3,
            store: Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
            typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            allowBlank: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' + '{value}' + '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'assessmentSchemeId',
            itemId: 'importMarksRemarksEvalautionPlanItemId',
            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanByCriteria'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            width: 256,
            displayField: 'value',
            queryParam: 'evaluationPlanNumber',
            minChars: 3,
            typeAhead: false,
            disabled: true,
            allowBlank: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'courseId',
            itemId: 'importMarksRemarksCourseItemId',
            store: Ext.create('Academia.store.attendance.CoursesForVariantMapping'),
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'courseName',
            minChars: 3,
            width: 256,
            typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            triggerAction: '',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'multiselectcombofield',
            name: 'courseVariants',
            itemId: 'importMarksRemarksCourseVariantItemId',
            store: Ext.create('Academia.store.attendance.CourseVariantMappedToPlanTemplate'),
            displayField: 'value',
            valueField: 'id',
            width: 462,
            maxLength: 9999,
            maxSelections: 9999,
            forceSelection: true,
            allowBlank: false,
            typeAhead: false,
            editable:false,
            disabled:true,
            submitValue: false,
            autoloadStore: false,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
            fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					},
					refresh: function( boundList, eOpts ){
						try{
							var combo = boundList.up('combo');
							try{
								var isDynamic = combo.up('form').down('#importMarksRemarksDetailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
							}
							catch(e){
								var isDynamic = false;
							}
							if(isDynamic==true || isDynamic=="true"){
								var newValue = combo.getValue();
								if(!isNullOrEmpty(newValue[0])){
									var allItems = combo.listKeyNav.boundList.all.elements;
									var selectedVariantId = 0;
									var selectedCourseId = 0;
									var comboStore = combo.getStore();
									if(typeof combo.getValue() == "string"){
										selectedVariantId = combo.getValue();
									}
									else{
										selectedVariantId = combo.getValue()[0].get('id');
									}
									if(selectedVariantId){
										var selectedRecord = comboStore.findRecord('id',selectedVariantId);
										var selectedCourseId = selectedRecord.get('courseId');
									}
									Ext.each(allItems, function(currentItem){
										var currentCourseVariantId = currentItem.viewRecordId;
										var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
										if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
											currentItem.classList.remove("disabledComboItem")
										}
										else{
											currentItem.classList.add("disabledComboItem");
										}
									});
								}
							}
						}
						catch(e){
							console.log(e);
						}
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
			listeners:{
				beforeselect:function(selModel,record,index){
					var combo = selModel.view.field;
					try{
						var isDynamic = combo.up('form').down('#importMarksRemarksDetailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(value[0].data.courseId != record.data.courseId){
								return false;
							}
						}
					}
					else{
						return true;
					}
				},
				change: function(combo, newValue, oldValue, eOpt){
					var allItems = combo.listKeyNav.boundList.all.elements;
					var selectedVariantId = 0;
					var selectedCourseId = 0;
					var comboStore = combo.getStore();
					try{
						var isDynamic = combo.up('form').down('#importMarksRemarksDetailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(typeof combo.getValue() == "string"){
							selectedVariantId = combo.getValue();
						}
						else{
							selectedVariantId = combo.getValue()[0];
						}
						if(!isNullOrEmpty(selectedVariantId)){
							if(selectedVariantId){
								var selectedRecord = comboStore.findRecord('id',selectedVariantId);
								var selectedCourseId = selectedRecord.get('courseId');
							}
							Ext.each(allItems, function(currentItem){
								var currentCourseVariantId = currentItem.viewRecordId;
								var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
								if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
									currentItem.classList.remove("disabledComboItem")
								}
								else{
									currentItem.classList.add("disabledComboItem");
								}
							});
						}
					}
				}
			}
        }, {
        	xtype: 'hidden',
        	name: 'courseVariantId'
        }, {
			xtype: 'customcombobox',
			name:'programId',
			itemId:'importMarksRemarksProgramIdQuickFiltr',
			store:'exam.importMarkRemark.ProgramForOtherStore',
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			autoloadStore: false,
			forceSelection:true,
			allowBlank:false,
			hidden:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'importMarksRemarksBatchIdQuickFiltr',
			store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchStore'),
			displayField:'value',
			queryParam:'batchName',
			minChars:3,
			valueField:'id',
			typeAhead:true,
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  ,
			disabled:true,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('BATCH'),
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'importMarksRemarksPeriodIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodStore'),
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			disabled:true,
			hidden:true,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('PERIOD')
		}]
    }, {
        xtype: 'fieldcontainer',
		layout: {
					type: 'table',
					columns: 3
				},
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'hidden',
            name: 'evaluationEventStatus'
        }, {
            xtype: 'hidden',
            name: 'isDynamicScheme'
        }, {
			xtype: 'multiselectcombofield',
			name: 'sectionIds',
			itemId:'importMarksRemarksSectionIdQuickFiltr',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionTemplateStore',//'coursetransaction.sectionmanagement.SectionsStore',
			displayField:'value',
			valueField:'id',
			disabled:true,
			width: 256,
			typeAhead:true,
			hidden:true,
			fieldLabel:getExaminationTranslation('SECTION'),
			submitValue: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}, {
            xtype: 'hidden',
            name: 'sectionId'
        }, {
            xtype: 'groupingcombobox',
            name: 'assessmentSchemeLevelId',
            itemId: 'importMarksRemarksEvalPlanLevelItemId',
            labelAlign: 'top',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            valueField: 'levelId',
            minChar: 3,
            disabled: true,
            forceSelection: true
        }, {
            xtype: 'customcombobox',
            name: 'assessmentEventId',
            itemId: 'importMarksRemarksDetailSequenceItemId',
            store: Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventForImportMarkRemark'),
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            typeAhead: true,
            disabled: true,
            fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
            allowBlank: false
			//margin: '0 0 0 10'
			},
			
      {
            xtype: 'customcombobox',
            name: 'validationOn',
            itemId: 'importMarksRemarksValiationOn',
            store: Ext.create('Ext.data.Store', {
            	fields: ['id', 'value'],
            	data: [{
            		id: 'ADMISSION_CODE',
            		value: getExaminationTranslation('IMPORT_MARK_REMARK_ADMISSION_CODE')
            	}, {
            		id: 'STUDENT_CODE',
            		value: getExaminationTranslation('IMPORT_MARK_REMARK_STUDENT_CODE')
            	}, {
            		id: 'EXTERNAL_REFERENCE',
            		value: getExaminationTranslation('IMPORT_MARK_REMARK_EXTERNAL_REFERENCE_1')
            	}]
            }),
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            fieldLabel: getExaminationTranslation('VALIDATION_ON'),
            allowBlank: false
        }, {
            xtype: 'customcombobox',
            name: 'importUtilityMasterId',
            itemId: 'importMarksRemarksModuleName',
            store: 'importutility.ModuleName',
            fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
            valueField: 'id',
            displayField: 'displayValue',
            typeAhead: true,
            forceSelection: true,
            allowBlank: false,
            readOnly: true
        }]
    }, {
		       xtype: 'fieldcontainer',
		       layout: 'hbox',
		       defaults: {
		           width: 256,
		           labelAlign: 'top'
		       },
		       items: []
		   }, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 536,
        fieldLabel: getCommonTranslation('UPLOAD_FILE'),
        labelAlign: 'top',
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'importMarkRemarkUploadFileField',
        name: 'file',
        allowBlank: false,
        validateOnChange: true,
        listeners: {
            change: function (fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
					} else {
						var form = fileField.up('form');
						// var structure=form.up('panel').down('#importMarksRemarksStructure');  
						var structure = form.up('importMarksRemarksStructure'); 
						var event = form.down('#importMarksRemarksDetailSequenceItemId');
						var multipleEventRemarkCheck = structure.down('#multipleEventRemarkCheck');

						if (multipleEventRemarkCheck && multipleEventRemarkCheck.getValue()) {
							event.setDisabled(true);
						} else {
							event.setDisabled(false);
						}

						form.isValid();
					}
                }
            }
        }
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        margin:'0 0 0 -22',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: getTranslation('UPLOAD_DATA'),
            formBind: true,
            itemId: 'marksRemarksUpload',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
    	html: '<b><span style="color: red;">' + getCommonTranslation('NOTE') + ': </span>' + getExaminationTranslation('IMPORT_MARK_REMARK_NOTE') + '</b>',
    	margin: '8 10 0 -6',
    	cls: 'note-section'
    }]
});