/**
 * @author sumit meena
 */
Ext.define('Academia.view.examinationcenters.markgrade.MarkGradeQuickSearch', {
	extend: 'Ext.form.Panel',
    alias: 'widget.markgradequicksearch',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins:"formlabelrequired",
    defaults: {
       labelAlign: 'top'
    },
    items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
    items: [
	{
		xtype : 'multiselectcombofield',
		name : 'academyLocation',
		width: 536,
		itemId:'academyLocationId',
		fieldLabel :getExaminationTranslation('ACADEMY_LOCATION'),
		store:'common.AcademyLocationNameSeparated',
		cls:'multiBrandCampusCls',
		valueField : 'id',
		displayField : 'value',
		
		fieldStyle:{
				maxHeight: '120px !important'
			},
	},{
      	 xtype : 'radiogroup',
    	 name:'gradingType',
    	 fieldLabel:getExaminationTranslation('GRADING_TYPE'),
    	 itemId:'gradingTypeItemId',
    	 hidden:true,
    	 
	   	 items : [{
	   		 boxLabel : getExaminationTranslation('EVALUATION_DETAIL_SEQUENCE'),
	   		 name : 'grade',
	   		 inputValue : false,
	   		 
	   	 },{
	   		 boxLabel : getExaminationTranslation('COURSE_GRADING'),
	   		 name : 'grade',
	   		 inputValue : true,
	   		 checked : true
	   		 
	   	 }]
	},{
        xtype: 'customcombobox',
        fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
        name: 'academicTerm',
        itemId: 'academicTerm',
        displayField: 'value',
        valueField: 'id',
		minChars:3,
		queryMode:'local',
        typeAhead: true,
        forceSelection: true,
        width: 256,
        hidden: false,
		minChars:3,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
                combo.bindStore(store)
            }
        }
    },/*{
	    xtype: 'customcombobox',
		name:'program',
		itemId:'programIdItemId',
		store:'attendance.AllProgramMappedByCourse',
		fieldLabel:getExaminationTranslation('PROGRAM'),
		displayField:'programName',
	    valueField:'programId',
		queryParam:'programId',
		minChars:3,
		//width: 536,
		typeAhead:false,
		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		enableKeyEvents  : 'true',
		hideTrigger:false,
		forceSelection:true,
		//allowBlank:false,
		hidden:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{programName}' +
				'</div>';
			}
		}  
   },*/{
   xtype: 'customcombobox',
   name:'program',
   store: 'program.ProgramCodeOrNameSmartSearch',
   itemId:'programIdItemId',
   fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
   valueField: 'id',
   displayField: 'valueCode',
   queryParam:'qry',
   minChars:3,
   allowBlank: true,
   typeAhead:false,
   hidden:true,
   emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
   forceSelection:true,
   listConfig: {
	   listeners: {
		   beforeshow: function(picker) {
			   picker.minWidth = picker.up('combobox').getSize().width;
		   }
	   },
	   loadingText: getCommonTranslation('SEARCHING'),
	   emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	   getInnerTpl: function() {
		   return '<div class="search-item">' +
		   '{code} / {value}'+ 
		   '</div>';
	   }
   }
    },{
		 xtype: 'customcombobox',
	     name: 'batchId',
	     store:'common.BatchesByProgramId',
	     displayField:'value',
	     valueField:'id',
	     itemId:'batchIdItemId',
	     forceSelection:true,
	     typeAhead:true,
	     disabled:true,
	     fieldLabel: getExaminationTranslation('BATCH'),
	     hidden:true,
	     queryParam:'batchId',
	     //allowBlank: false
  },]
    },{
              xtype: 'fieldcontainer',
              layout: 'hbox',
              defaults: {
                  width: 256,
                  labelAlign: 'top'
              },
              items: [{
					 xtype: 'customcombobox',
				     name: 'periodId',
				     fieldLabel: getExaminationTranslation('PERIOD'),
				     store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				     displayField:'value',
				     valueField:'id',
				     itemId:'periodIdItemId',
				     forceSelection:true,
				     typeAhead:true,
				     disabled:true,
				     hidden:true,
				     queryParam:'periodId',
				    // allowBlank: false
			 },{
					 xtype: 'customcombobox',
				     name: 'sectionId',
				     fieldLabel: getExaminationTranslation('SECTION'),
				     store:'coursetransaction.sectionmanagement.SectionsStore',
				     displayField:'value',
				     valueField:'id',
				     itemId:'sectionIdItemId',
				     typeAhead:true,
				     disabled:true,
				     hidden:true,
				     queryParam:'sectionId',
				     forceSelection:true,
				     editable:false,
				    // allowBlank: false
				 }]
      	},{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{                	
                	xtype: 'customcombobox',
        			name:'courseId',
        			itemId:'courseItemId',
        			store: 'examinationcenters.markgrade.EvalRelativeGradeTypeCourseStore',
        			//store:'coursetransaction.studymaterialdistribution.CoursesForEventStore',
        			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
        			valueField: 'id',
        			displayField: 'value',
        			queryParam:'name',
        			minChars:3,
        			typeAhead:false,
        			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        			enableKeyEvents  : 'true',
        			hideTrigger:false,
        			forceSelection:true,
        			//width: 536,
        			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        			listConfig: {
        				listeners: {
        				beforeshow: function(picker) {
        					picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				}
        			}
               
            },{
                xtype: 'multiselectcombofield',
                name: 'courseVariant',
                itemId: 'courseVariantItemId',
                store: 'attendance.VariantMappedToSpecialGrade',
                fieldLabel: getExaminationTranslation('COURSE_VARIANT'),
                displayField: 'value',
                valueField: 'id',
                minChars: 3,
                typeAhead: true,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: 'true',
                hideTrigger: false,
                forceSelection: true,
                disabled: true,
                cls:'placementProgramMultiselect',
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.width = 'auto';
                            setTimeout(function() {
                                picker.el.dom.style.width = 'auto';
                                picker.el.dom.style.minWidth = picker.up('combobox').getSize().width + 'px';
                            }, 10);
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                }
            }]
        	},{
                xtype: 'fieldcontainer',
                layout: 'hbox',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [,{
                	xtype: 'customcombobox',
                    name: 'gradeStatus',
                    store:'examinationcenters.markgrade.GradeStatus',
                    fieldLabel:getExaminationTranslation('GRADE_STATUS'),
                    displayField:'value',
                    valueField:'id',
                    forceSelection:true,
                    typeAhead:true,
                    minChars:1,
                    editable : false,
                }/*{
                	 xtype: 'customcombobox',
                     store:'examinationcenters.markgrade.EvalDetailSeqMarkGrade',
                     name: 'evalDetailSeq',
                     itemId:'evalDetailSeqItemId',
                     fieldLabel:getExaminationTranslation('EVALUATION_DETAIL_SEQUENCE'),
                     displayField:'detailSequenceNumber',
                     valueField:'id',
                     forceSelection:true,
                     typeAhead:true,
                     minChars:3,
                     disabled:true
                 }*/]
        	}/*{
                xtype: 'fieldcontainer',//TODO
                layout: 'hbox',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: []
           }*/,{
	            xtype: 'fieldcontainer',
	            width: 'auto',
	    		layout : {
	    			type : 'hbox'
	    		},
	    		cls: 'customSearchPanelBtnsFieldContainerCls',
	            items: [{
	                xtype: 'button',
	                text: getCommonTranslation('SEARCH'),
	                itemId: 'quickSearchId',
	                buttonAlign: 'left',
	                ui: 'CustomBtnSubmit',
	                scale: CONSTANTS.BUTTONSIZE,
	                formBind:true
	            },{
	            	xtype: 'button',
	    			itemId: 'resetBtn',
	    			text: getCommonTranslation('RESET'),
	    			ui:'CustomBtnCancel',
	    			scale: CONSTANTS.BUTTONSIZE
	            }]
        }]
    
});