/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.markgrade.markgradedetail.markgradetransformation.AddGradeTypeWin', {
	extend: 'Ext.window.Window',
	alias : 'widget.addgradetypewin',
	title : getExaminationTranslation('ADD_GRADE'),
	frame: true,
	autoScroll:true,
	modal:true, 
	method: 'POST',
	height: '40%',
	width: '40%',
	items : [{
		xtype: 'form',
		standardSubmit : false,
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top'
		},
		items: [{
		xtype:'hidden',
		name:'id'
	},{
		xtype:'hidden',
		name:'extraId'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [/*{
            xtype: 'customcombobox',
            name: 'gradeType',
            itemId:'gradeTypeItemId',
            fieldLabel: getExaminationTranslation('GRADE_TYPE'),
           //store:'gradeMaster.GradeTypeNameValueStore',
            displayField:'value',
            valueField:'value',
            allowBlank: false,
            hidden:true
        },*/{
            xtype: 'textfield',
            name: 'gradeName',
            itemId:'gradeName',
            fieldLabel:getExaminationTranslation('GRADE_NAME'),
            maxLength:20,
            allowBlank: false
        },{
        	/**
        	 * This field is moved to this row because IS_GRADE_PART_OF_GROUP, minPercent and maxPercent are hidden.
        	 */
        	xtype: 'numberfield',
            name: 'gradePoint',
            itemId:'gradePoint',
            fieldLabel: getExaminationTranslation('GRADE_POINT'),
            minValue : 0,
            allowDecimals:true,
        	hideTrigger:true,
        	mouseWheelEnabled:false,
            allowBlank: false
        }]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'numberfield',
            name: 'gradeRangeFrom',
            itemId:'gradeRangeFrom',
            fieldLabel:getExaminationTranslation('GRADE_POINT_RANGE_FROM'),
            minValue : 0,
        	allowDecimals:true,
        	hideTrigger:true,
        	mouseWheelEnabled:false,
            allowBlank: false,
	   	    validator : function(val) {
	       		 var maxValuefield = this.nextSibling();
	       		 var maxValue = maxValuefield.getValue();
	       		 if (maxValue != null) {
	       			 if (val < maxValue) {
	       				 maxValuefield.clearInvalid();
	       				 return true;
	       			 } else {
	       				 return getCommonTranslation('LESS_THAN_MAX_VALUE');
	       			 }
	       		 } else {
	       			 return true;
	       		 }
	       	   }
    }, {
        xtype: 'numberfield',
        name: 'gradeRangeTo',
        itemId:'gradeRangeTo',
        fieldLabel:getExaminationTranslation('GRADE_POINT_RANGE_TO'),
        minValue : 0,
    	allowDecimals:true,
    	hideTrigger:true,
    	mouseWheelEnabled:false,
        allowBlank: false,
	   	    validator : function(val) {
	   		 var minValueField =this.previousSibling();
	   		 var minValue = minValueField.getValue();
	   		 if (minValue != null) {
	   			 if (val > minValue) {
	   				 minValueField
	   				 .clearInvalid();
	   				 return true;
	   			 } else {
	   				 return getCommonTranslation('MORE_THAN_MIN_VALUE');
	   			 }
	   		 } else {
	   			 return true;
	   		 }
	   	  }
    }]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'gradeMasterAddButtonId',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			text : getCommonTranslation('CANCEL'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
	}]
});