/**
 * @author sumit.meena
 */
var studentMarksheetGrid = Ext.create('Academia.store.examinationcenters.marksheet.StudentMarksheetStore');
Ext.define('Academia.view.examinationcenters.marksheet.student.StudentMarksheetGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentmarksheetgrid',
	store : studentMarksheetGrid,
    border: true,
    frame:false,
    selType:'checkboxmodel',
    title:getExaminationTranslation('STUDENTS_MARKSHEETS_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selModel: {
		 //showHeaderCheckbox: false,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false,
	     //injectCheckbox:1
    },
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'marksheetgenerationform':1
		}
	},
    isGridConfigurable: true,
    enableColumnHide: false,
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : studentMarksheetGrid,
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],*/
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
 },
 tbar: [{
    	xtype: 'button',
		itemId: 'btnUncheckedAll',
		//disabled:true,
		text:getCommonTranslation('UNCHECK_ALL')
	},{
		xtype: 'button',
		itemId: 'btnDeleteRecord',
		disabled:true,
		text:getExaminationTranslation('DELETE_RECORD')
	}, {
		xtype: 'splitbutton',
		text: getCommonTranslation('MOREACTIONS'),
		itemId: 'marksheetGridMoreAction',
		menu: [{
			itemId: 'btnGenerateMarksheet',
			disabled:true,
			text:getCommonTranslation('GENERATE_MARKSHEET')
		},{
			itemId: 'btnPublishMarksheet',
			disabled:true,
			text:getCommonTranslation('PUBLISH_MARKSHEET')
		},{
			itemId: 'btnUNPublishMarksheet',
			disabled:true,
			text:getExaminationTranslation('UNPUBLISH_MARKSHEET')
		},{	
			//xtype: 'button',
			itemId: 'btnSetupMarksheetJob',
			tooltip: getExaminationTranslation('SETUP_MARKSHEET_JOB'),
			//scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SETUP_MARKSHEET_JOB'),
		},{
			//xtype: 'button',
			itemId: 'btnDownloadAllMarksheet',
			disabled:true,
			text:getCommonTranslation('DOWNLOAD_ALL_MARKSHEET')
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
    columns: [{
            header : getCommonTranslation('STUDENT_ID'),
  	       dataIndex : 'studentCode',
  	       flex:1
  	  },{
		  	header : getCommonTranslation('ADMISSION_NO'),
		  	dataIndex : 'admissionCode',
		  	flex:1
       },{
            header : getCommonTranslation('STUDENT_NAME'),
	        dataIndex : 'studentName',
	        flex:1
       },{
    	   header : getCommonTranslation('FIRST_NAME'),
    	   dataIndex : 'firstName',
    	   flex : 1,
			hidden :true
       },{
			header : getCommonTranslation('MIDDLE_NAME'),
			dataIndex : 'middleName',
			flex : 1,
			hidden :true
       },{
    	   header : getCommonTranslation('LAST_NAME'),
    	   dataIndex : 'lastName',
    	   flex : 1
	},{
           header : getCommonTranslation('PROGRAM'),
	       dataIndex : 'programName',
	       flex:1
       },{
           header : getCommonTranslation('BATCH'),
	       dataIndex : 'batchName',
	       flex:1
       },{
           header : getCommonTranslation('PERIOD'),
	       dataIndex : 'periodName',
	       flex:1,
	       hidden:true
       },{
           header : getCommonTranslation('SECTION'),
	       dataIndex : 'sectionName',
	       flex:1
	  },{
          header : getCommonTranslation('ISPUBLISHMARKSHEET'),
	       dataIndex : 'isPublishMarksheet',
	       renderer:function(value,meta,record){
				 if(!isNullOrEmpty(record.data.financeHoldStatus) && (record.data.financeHoldStatus=="Hold" && value)){
						return '<sapn style=\'color:red\'>' + getExaminationTranslation('HOLD_FOR_STUDENT') + '</span>';
					}else if(value){
						return 'Published'
					}else{
						return value = 'Not Published';
					}
				
			},
	       flex:1
	  },{
          header : getCommonTranslation('REPORT_STATUS'),
	       dataIndex : 'calculationDone',
	       flex:1,
	       renderer:function(value,rec,record){
	    	   if(value == true || value == 'true'){
	    		    rec.tdAttr = 'data-qtip="' + "Calculation Done" + '"';
		    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 16px;max-height: 106px;min-width: 16ch;max-width: 17ch;';
		    	
		    	     return '<div class="reportStatusTrueCls"></div>'; 
	    	   }else if(value == false || value == 'false'){
	    		   rec.tdAttr = 'data-qtip="' +"Calculation Running" + '"';
		    	   rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 16px;max-height: 106px;min-width: 16ch;max-width: 17ch;';
		    	
		    	     return '<div class="reportStatusFalseCls"></div>';
	    	   }else{
	    		  return value;
	    	   }
	    	    
	       },
	       
	  },{
	       header : getCommonTranslation('MARKSHEET_PATH'),
		   dataIndex : 'marksheetPath',
		   flex:1,
		   renderer:function(value){
			   if(!isNullOrEmpty(value)){
				   return "<a href='#'>"+value+"</a>";
			   }
		   }
	 }, {
			header: getCommonTranslation('PREVIEW'),
			dataIndex: 'previewMarksheet',
			renderer: function(value, meta, record) {
				if(!isNullOrEmpty(record.data.marksheetPath) && isImageOrPDFDocument(record.data.marksheetPath)){
					return '<a  href="#" class="x-border-box x-btn x-btn-CustomBtnCancel-small x-btn-CustomBtnCancel-small-noicon x-btn-noicon x-noicon x-unselectable" style="text-align: center; text-decoration: none; font-size: 12px;font-weight: bold;font-family: sans-serif,Myriad Pro;color: #666 !important;padding: 8px 10px;" >'+getCommonTranslation('PREVIEW')+'</a>';
				}
				else{
					return "-";
				}
			}
		}],
	   // listeners : {
	        /*select: function (obj, record,rowIndex, e) {
	        	*//**
	        	 * this condition is for student's can't selected with students whose marksheet already created.   
	        	 *//*
	        	if(obj.selected.items.length>1){
	        		var newLength=obj.selected.items.length-2;
	        		if((!obj.selected.items[newLength].data.isStudentMapped && record.data.isStudentMapped) ||
	        		    (!record.data.isStudentMapped && obj.selected.items[newLength].data.isStudentMapped)){
                            obj.deselect(record);
		  	    	  showWarningMessage(getCommonTranslation('ALERT'),getExaminationTranslation('STUDENT_MARKSHEET_WITHOUT_MARKSHEET_CANNOT_BE_SELECTED_TOGETHER'));
	        	   }
	        	}
	        }*/
	  //  }
});
