/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.remark.EvaluationRemarkWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.evaluationremarkwin',
	title:getExaminationTranslation('REMARK'),
	frame: true,
	autoScroll:true,
	modal:true,
	width:'70%',
	method: 'POST',
	height:480,
//	maxHeight: 800,
	items: [{
		xtype: 'form',
		items:[{
    		xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: '30%',
    			//labelWidth:60,
                labelAlign: 'top'
    		},
    		items:[{
	    		xtype:'displayfield',
		    	name:'studentName',
	    		fieldLabel:'<b>'+getExaminationTranslation('STUDENT_NAME')+'</b>'
    	    },{
	    		xtype:'displayfield',
	    		name:'gender',
	    		fieldLabel:'<b>'+getExaminationTranslation('GENDER')+'</b>'
    	    },{
	    		xtype:'displayfield',
	    		name:'totalMarkGrade',
	    		fieldLabel:'<b>'+getExaminationTranslation('OBTAINED_MARKS_GRADE')+'</b>',
	    		renderer:function(val,rec,e){
					if (!isNullOrEmpty(val)) {
						return val;
					} else {
						return '-';
					}
	        	},
    	    }]
		},{
			xtype: 'fieldcontainer',
			plugins : "formlabelrequired",
			//height:160,
			defaults: {
				labelAlign: 'top',
			},
			standardSubmit: false,
			items: [{
				xtype: 'textarea',
				name: 'evaluationRemark',
				itemId:'evaluationremark_hindi',
				//	regex:'[\u0900-\u097F]+',
				fieldLabel: '<b>'+getExaminationTranslation('REMARK')+'</b>',
				height:250,
				width:'100%',
				maxLength:1500,
				enterIsSpecial:true,
			},{
				xtype:'displayfield',
				name:'remarkNotice',
				itemId:'remarkNoticeId',
				width:'100%',
				value: '<span class="maxCharacterCls">'+getExaminationTranslation('MAX_CHARACTER_LENGTH')+" "+1500+'/'+1500+'</span>',


			}]
		}, { 	
			xtype:'fieldcontainer',
			width:'100%',
			layout: 'hbox',
			itemId: 'uploadImgContainer',
			name: 'uploadImgContainer',
			hidden: true,
			items: [{
				xtype: 'photouploadform',
				itemId: 'studentPhotoUploadForm',			
				width:280,
				listeners:{
					beforeRender: function(){
						this.down('#photoFileImage').setFieldLabel(getCommonTranslation('PHOTO_IMAGE_SIZE'));
						var win = this.up('window');
						var evidenceLinkBtn = this.down('#evidenceLink');
						Ext.defer(function() {
							var documentRecord = win.documentRecord;
							if(documentRecord && documentRecord.data.evidence) {
								var id = documentRecord.data.id;
								var fileExtension = documentRecord.data.evidence.split('.').pop();
								if(!isNullOrEmpty(id) && id){
									Ext.Ajax.request({
										type: 'rest',
										url: SERVERURL.PATH_PREVIEW_EVIDENCE + '?evalId=' + id,
										method: 'GET',
										success: function(res, action) {
											var responseTxt = res.responseText;
											if(responseTxt != ''){
												evidenceLinkBtn.show();
												evidenceLinkBtn.setText(documentRecord.data.studentName);
												evidenceLinkBtn.fileExtension = fileExtension;
												evidenceLinkBtn.setHref("data:image/"+fileExtension.toLowerCase()+";base64," + encodeURI(responseTxt) + "");
											}
											else{
												Ext.query('.documentPreviewPanelDivCls')[0].innerHTML = "Photo Not Found";
												win.down('#previewImgDownloadBtn').hide();
											}
										}
									});
								}
							}
						}, 1000);
					}
				}
			}, {
				xtype:'button',
				text:'Snapshot',
				itemId: 'photoFileImage',
			    ui: 'CustomBtnSubmit',
			    width:65,
			    style: {
					marginTop: '32px',
					marginLeft: '10px'
				},
			    listeners:{
			    	click : function(){
			    		var formWindow = Ext.widget('imagecapturewindow');
			    		formWindow.show();
			    	}
			    }
			}, {
				xtype:'button',
				text:'Remove',
				itemId: 'profilePhotoRemove',
			    ui: 'CustomBtnSubmit',
			    width:60,
			    style: {
					marginTop: '32px',
					marginLeft: '20px'
				}			    
			}]
		}, { 	
		   xtype:'fieldcontainer',
    	   width:'auto',
		   items: [{
		    	 xtype: 'button',
				 action: 'Submit',
				 text: getFeeAndPaymentCommonTranslation('SAVE'),
				 formBind: true,
				 itemId: 'submitBtnWin',
				 ui: 'CustomBtnSubmit',
				 scale: CONSTANTS.BUTTONSIZE
		      },{
				 xtype: 'button',
				 text: getFeeAndPaymentCommonTranslation('CANCEL'),
				 ui: 'CustomBtnCancel',
				 itemId: 'cancelBtn',
				 scale: CONSTANTS.BUTTONSIZE
		      }]
	     }]
	}]
});