/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.reports.EventLevelReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.eventlevelreportgrid',
	store :  'examinationcenters.reports.EventLevelReportStore',
	title :  getExaminationTranslation('EVENT_LEVEL_REPORT'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.EventLevelReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
   tbar : [{
		xtype : 'button',
		itemId : 'exportEvenLevelReportsId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		formBind:true,
//		hidden:true
	}],
	columns: [{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex : 1,
		hidden:true
	},
	{
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex : 1,
	},
	{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
	},
	{
		header :getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1
	},{
		header : getExaminationTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_PLAN_NUMBER'),
		dataIndex : 'evaluationPlanName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_TYPE'), 
		dataIndex : 'evaluationTypeName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_SUB_TYPE'),
		dataIndex : 'evaluationSubTypeName',
		flex : 1,
	},
	{
		header : getCommonTranslation('EVALUATION_METHOD'),
		dataIndex : 'evaluationMethodName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVENT_NAME'),
		dataIndex : 'evaluationEventName',
		flex : 1
	},
	{
		header : getExaminationTranslation('OUT_OF_MARKS'),
		dataIndex : 'outOfMarks',
		flex : 1
	},{
		header : getExaminationTranslation('EFFECTIVE_MARKS'),
		dataIndex : 'effectiveMarks',
		flex : 1
	},
	{
		header : getExaminationTranslation('PENALTY_MARKS'),
		dataIndex : 'penultyMarksGiven',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('GRACE_MARKS'),
		dataIndex : 'graceMarksGiven',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('MARKS_OBTAIN'),
		dataIndex : 'obtainedMarks',
		flex : 1
	},
	{
		header : getExaminationTranslation('RESULT_STATUS'),
		dataIndex : 'examResultStatus',
		flex : 1
	}]
});
