/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.reports.ExamLevelReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.examlevelreportgrid',
	store :  'examinationcenters.reports.ExamLevelReportStore',
	title :  getExaminationTranslation('EXAM_RANK_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.ExamLevelReportStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
   columns: [{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex : 1,
		hidden:true
	},
	{
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex : 1
	},
	{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1
	},
	{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},
	{
		header :getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1
	},{
		header : getExaminationTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_PLAN_NUMBER'),
		dataIndex : 'evaluationPlanName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_TYPE'), 
		dataIndex : 'evaluationTypeName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_SUB_TYPE'),
		dataIndex : 'evaluationSubTypeName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVALUATION_METHOD'),
		dataIndex : 'evaluationMethodName',
		flex : 1
	},
	{
		header : getCommonTranslation('EVENT_NAME'),
		dataIndex : 'evaluationEventName',
		flex : 1,
		  sortable:true,
	      renderer:function(value,meta,record){
	    	  if(record.data.whetherDynamicScheme){
	    		  return record.data.evaluationEventName;
	    	  }else{
	    		  return value;
	    	  }
	      }
	},{
		header : getExaminationTranslation('ATTENDANCE_STATUS'),
		dataIndex : 'attendanceStatus',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('OUT_OF_MARKS'),
		dataIndex : 'outOfMarks',
		flex : 1,
		hidden:true
	},{
		header : getExaminationTranslation('EFFECTIVE_MARKS'),
		dataIndex : 'effectiveMarks',
		flex : 1,
		hidden:true

	},
	{
		header : getExaminationTranslation('MARKS_OBTAIN'),
		dataIndex : 'obtainedMarks',
		flex : 1,
		hidden:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.examResultStatus) && (record.data.examResultStatus=="ABSENT" || record.data.examResultStatus=="Absent")){
				return "Absent";
			}else{
				return value;
			}
		}
	},
	{
		header : getExaminationTranslation('GRADE_OBTAINED'),
		dataIndex : 'grade',
		flex : 1,
		hidden:true
	},{
		header : getExaminationTranslation('GRADE_OBTAINED_FROM'),
		dataIndex : 'gradeObtainedFrom',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('PENALTY_MARKS'),
		dataIndex : 'penultyMarksGiven',
		flex : 1,
		hidden:true
	},
	{
		header : getExaminationTranslation('GRACE_MARKS'),
		dataIndex : 'graceMarksGiven',
		flex : 1,
		hidden:true
	},{
		header : getExaminationTranslation('COURSE_RANK'),
		dataIndex : 'courseRank',
		flex : 1
	},{
		header : getExaminationTranslation('RESULT_STATUS'),
		dataIndex : 'examResultStatus',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value))
				return getExaminationTranslation(value);
			else
				return ''
		}
	},{
		header : getExaminationTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		hidden:true
	},{
		header : getExaminationTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		hidden:true
	},{
		header : getExaminationTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('REVISED_GRADE_OBTAINED'),
		dataIndex : 'revisedGrade',
		flex : 1,
		hidden:true
	}]
});
