/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.GPAReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.gpareportform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{

		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
		},
		xtype:'panel',
		cls: 'panelNoSpace',
		style:{marginLeft:'-2px !important'},
		items:[{
			xtype: 'radiogroup',
			itemId:'examWiseItemId',
			columns: 2,
			items: [
			        { boxLabel: getExaminationTranslation('EXAM_WISE'), name: 'isExamWise', inputValue: true},
			        { boxLabel: getExaminationTranslation('PROGRAM_WISE'), name: 'isExamWise', inputValue: false,checked:true}
			        ]
		}]
	},{

		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			name : 'academicTermE',
			itemId : 'academicTermEId',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store :Ext.create('Academia.store.common.AcademicTermStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection:true,
			typeAhead:false,
		 },{
			xtype: 'customcombobox',
			name:'evaluationGroup',
			itemId:'evaluationGroupItemId',
			store:'examinationcenters.reports.EvaluationGroupFilterStore',
			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			hidden:true,
			// code added for V2D-433840
			forceSelection:true,
			allowBlank:false,
			typeAhead:true,
			queryParam:'textSearch',
			minChars:3,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		itemId:'groupCont',
		hidden:true,
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'groupProgramId',
			itemId:'groupProgramId',
			store:'examinationcenters.manageEvaluation.evaluationgroup.EGProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			disabled:true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'groupBatchId',
			itemId:'groupBatchId',
			store:'examinationcenters.manageEvaluation.evaluationgroup.EGBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:true,
			queryParam:'name',
			minChars:3,
			disabled:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'groupPeriodId',
			itemId: 'groupPeriodId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			queryParam:'name',
			typeAhead:false,
			disabled:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{
    	xtype: 'fieldcontainer',
    	width: '100%',
		layout : 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [ {
        	xtype: 'customcombobox',
            name: 'programCategory',
            itemId:'programCategoryId',
            fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
            store:'program.ProgramCategoryStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true
        },{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('INTAKE_YEAR'),
		name : 'intakeYear',
		itemId : 'intakeYear',
		displayField:'value',
		valueField:'id',
		width: 256,
		typeAhead:true,
		forceSelection:true,
		minChars:3,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}'  +
				'</div>';
			}
		},
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.common.IntakeYearStoreByBatchId');
				combo.bindStore(store)
			}
		}
	},{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
		name : 'academicTerm',
		itemId : 'academicTerm',
		displayField : 'value',
		valueField : 'id',
		typeAhead : true,
		forceSelection : true,
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.program.AcademicTermByProgramCategoryStore');
				combo.bindStore(store)
			}
		}
	}]},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		itemId:'programCont',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'proProgramId',
			itemId:'proProgramId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCourseByCourseIdStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueSecondValue',
			queryParam:'programName',
			minChars:3,
			//width: 536,
			//allowBlank:false,
			//typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR')
			/*listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}*/
		},{
			xtype: 'customcombobox',
			name:'proBatchId',
			itemId:'proBatchId',
			store:'program.programbatchdetail.ProgramBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			//allowBlank:false,
			typeAhead:false,
			disabled:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'proPeriodId',
			itemId: 'proPeriodId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:false,
			disabled:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '35px!important',paddingTop:'18px!important'}, 
		width:'100%',
		itemId:'moreFilterId',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 536,
				labelAlign: 'top',
			},
			items:[/*{
			xtype: 'multiselectcombofield',
			itemId: 'userItemId',
			name: 'usersId',
			fieldLabel: getTransportTranslation('USER'),
			store:'examinationcenters.reports.ExaminationReportUserStore',	    
			valueField: 'id',
			displayField: 'value',
			width: 536
		}*/{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:'examinationcenters.reports.EvaluationProgRankBasedStudentListStore',
			fieldLabel:getExaminationTranslation('ADMISSIONID_STUDENTID_STUDENTNAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: 'all',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		}]
		},{
			xtype : 'fieldcontainer',
			width: '100%',
			itemId:'sgpaRangeId',
			defaults : {
				width: 536,
				labelAlign : 'top'
			},
			items : [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getExaminationTranslation('SGPA_RANGE')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{ 
				xtype : 'fieldcontainer',
				width: '100%',
				layout:'hbox',
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				items : [{
					xtype: 'numberfield',
					name: 'sgpaRangeFrom',
					itemId:'sgpaRangeFrom',
					fieldLabel: getExaminationTranslation('FROM'),
					minValue:0,
					maxValue:100,
					allowDecimals:true,
					hideTrigger:true,
					mouseWheelEnabled:false,
					validator : function(val) {
						var maxValuefield = this.nextSibling();
						var maxValue = maxValuefield.getValue();
						if (maxValue != null &&  !isNullOrEmpty(val)) {
							if (val <= maxValue) {
								maxValuefield.clearInvalid();
								return true;
							} else {
								return getCommonTranslation('LESS_THAN_MAX_VALUE');
							}
						} else if(maxValue==null){
							maxValuefield.clearInvalid();
							return true;
						} else if (maxValue != null &&  isNullOrEmpty(val)) {
								return true;
						} else {
							return true;
						}
					}
				},{
					xtype: 'numberfield',
					name: 'sgpaRangeTo',
					itemId:'sgpaRangeTo',
					fieldLabel: getExaminationTranslation('TO'),
					minValue:0,
					maxValue:100,
					allowDecimals:true,
					hideTrigger:true,
					mouseWheelEnabled:false,
					validator : function(val) {
						var minValueField =this.previousSibling();
						var minValue = minValueField.getValue();
						if (minValue != null &&   !isNullOrEmpty(val)) {
							if (val >= minValue) {
								minValueField
								.clearInvalid();
								return true;
							} else {
								return getCommonTranslation('MORE_THAN_MIN_VALUE');
							}
						} else if(minValue==null){
							minValueField.clearInvalid();
							return true;
						} else if (minValue != null &&   isNullOrEmpty(val)) {
								return true;
						}else {
							return true;
						}
					}
				}]
			}
			]},{
				xtype : 'fieldcontainer',
				width: '100%',
				itemId:'cgpaRangeId',
				defaults : {
					width: 536,
					labelAlign : 'top'
				},
				items : [{
					xtype:'displayfield',
					value:'<b class="menu-title">'+getExaminationTranslation('CGPA_RANGE')+'</b>',
					style: {
						textDecoration: "underline"
					}
				},{ 
					xtype : 'fieldcontainer',
					width: '100%',
					layout:'hbox',
					defaults : {
						width: 256,
						labelAlign : 'top'
					},
					items : [{
						xtype: 'numberfield',
						name: 'cgpaRangeFrom',
						itemId:'cgpaRangeFrom',
						fieldLabel: getExaminationTranslation('FROM'),
						minValue:0,
						maxValue:100,
						allowDecimals:true,
						hideTrigger:true,
						mouseWheelEnabled:false,
						validator : function(val) {
							var maxValuefield = this.nextSibling();
							var maxValue = maxValuefield.getValue();
							if (maxValue != null &&  !isNullOrEmpty(val)) {
								if (val <= maxValue) {
									maxValuefield.clearInvalid();
									return true;
								} else {
									return getCommonTranslation('LESS_THAN_MAX_VALUE');
								}
							} else if(maxValue==null){
								maxValuefield.clearInvalid();
								return true;
							} else if (maxValue != null &&  isNullOrEmpty(val)) {
									return true;
							} else {
								return true;
							}
						}
					},{
						xtype: 'numberfield',
						name: 'cgpaRangeTo',
						itemId:'cgpaRangeTo',
						fieldLabel: getExaminationTranslation('TO'),
						minValue:0,
						maxValue:100,
						allowDecimals:true,
						hideTrigger:true,
						mouseWheelEnabled:false,
						validator: function(val) {
							var minValueField =this.previousSibling();
							var minValue = minValueField.getValue();
							if (minValue != null &&   !isNullOrEmpty(val)) {
								if (val >= minValue) {
									minValueField
									.clearInvalid();
									return true;
								} else {
									return getCommonTranslation('MORE_THAN_MIN_VALUE');
								}
							} else if(minValue==null){
								minValueField.clearInvalid();
								return true;
							} else if (minValue != null &&   isNullOrEmpty(val)) {
									return true;
							}else {
								return true;
							}
						}
					}]
				}
				]}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
