/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.GPAReportGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.gpareportgrid',
	store: 'examinationcenters.reports.GPAReportStore',
	title: getExaminationTranslation("GPA_REPORT_LIST"),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.reports.GPAReportStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	 tbar: [{
			xtype: 'button',
			itemId: 'gpaExportReport',
			tooltip : getCommonTranslation('EXPORTREPORTS'),
			text : getCommonTranslation('EXPORTREPORTS'),
			disabled: true
		}],
	columns: [{
		header:  getExaminationTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.1,
		sortable:true,
		/*renderer:function(value,meta,record){
			if(record.data.admissionCode == 0){
				return record.data.admissionCode ;
			} else {
				return '<a href=#>'+record.data.admissionCode +'</a>'
			}
		}*/
	},{
		header:  getExaminationTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(record.data.studentCode == 0){
				return record.data.studentCode ;
			} else {
				return '<a href=#>'+record.data.studentCode +'</a>'
			}
		}
	},{
		header:  getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('PROGRAM_NAME'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('BATCH_NAME'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('PERIOD_NAME'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('SGPA'),
		dataIndex: 'sgpa',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('CGPA'),
		dataIndex: 'cgpa',
		flex:.1,
		sortable:true
	},{
		header:  getExaminationTranslation('REVISED_SGPA'),
		dataIndex: 'revisedSGPA',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:  getExaminationTranslation('REVISED_CGPA'),
		dataIndex: 'revisedAccCGPA',
		flex:.1,
		sortable:true,
		hidden:true
	}]
});
