/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.reports.GradeAverageReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.gradeaveragereportfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	standardSubmit : false,
	modal: true,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			allowBlank: false,
			width: 256,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStoreByBatchId');
					combo.bindStore(store)
				}
			}
		},{
        	xtype: 'customcombobox',
			name: ' programGroup',
			itemId:'programGroup',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:'program.ProgramGroupByAccessibleALStore',
			editable: true,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			width: 256,
        }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:'examinationcenters.reports.ExamGradeReportProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueSecondValue',
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
			allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'program.programbatchdetail.ProgramBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			disabled:true,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			//width: 536,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'sectionId',
			itemId: 'sectionItemId',
			store:'examinationcenters.reports.ExaminationgGradeAverageReportSectionStore',
			fieldLabel:getExaminationTranslation('SECTION'),
			valueField: 'id',
			displayField: 'value',
			width: 536,
			disabled:true,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			cls:'placementProgramMultiselect',
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: '100%',
		defaults: {
			//width: 536,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			store:'examinationcenters.reports.ExaminationReportCourseStore',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'evaluationLevel',
			itemId: 'evaluationLevelItemId',
//			store:'examinationcenters.marksheet.CalculateAverageEvaluationLevelType',
			store:'examinationcenters.marksheet.GradeAverageReportEvaluationLevelStore',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank: false,
			typeAhead:true,
			minChars:3,
			width: 256,
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
			disabled:true,
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'evalLevelName',
			itemId: 'evalLevelName',
			store:'examinationcenters.calculateAverage.GradeAverageReportEvalLevelTypeListStore',
			fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
			displayField:'value',
			valueField:'value',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			//allowBlank: false,
			cls:'placementProgramMultiselect',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			width: 536,
			allowDeselect: true,
			selectEvent: false,
			listConfig: {listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
					picker.width = 'auto';
					setTimeout(function(){
						picker.el.dom.style.width='auto';
						picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
					},10);
				}/*,
				deselect: function(combo, record, index, eOpts) {
					var me = this;
					if(me.up('combobox').selectEvent==false){
						if(combo.getSelection().length==0){
							console.log('a');
							var gradeaveragereportgrid = this.up('gradeaveragereportstructure').down('#gradeaveragereportgrid');
							gradeaveragereportgrid.down('#gradeAverageExportReport').setDisabled(true);
						}
						else {
							console.log('b');
							var gradeaveragereportgrid = this.up('gradeaveragereportstructure').down('#gradeaveragereportgrid');
							gradeaveragereportgrid.down('#gradeAverageExportReport').setDisabled(false);
						}
						me.up('combobox').selectEvent=true;
						setTimeout(function(){
							me.up('combobox').selectEvent=false;
						},300);
						return false;
					}
				},
				select: function(combo, record, index, eOpts) {
					var me= this;
					me.up('combobox').selectEvent=true;
					if(combo.getSelection().length==0){
						console.log('c');
						var gradeaveragereportgrid = this.up('gradeaveragereportstructure').down('#gradeaveragereportgrid');
						gradeaveragereportgrid.down('#gradeAverageExportReport').setDisabled(true);
					}
					else {
						console.log('d');
						var gradeaveragereportgrid = this.up('gradeaveragereportstructure').down('#gradeaveragereportgrid');
						gradeaveragereportgrid.down('#gradeAverageExportReport').setDisabled(false);
					}
					setTimeout(function(){
						me.up('combobox').selectEvent=false;
					},300);
					return false;
				}*/
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}' +
				'</div>';
			}},
			listeners: {
				blur: function(combo){
					if(combo.getValue().length==0){
						var gradeaveragereportgrid = this.up('gradeaveragereportstructure').down('#gradeaveragereportgrid');
						gradeaveragereportgrid.down('#gradeAverageExportReport').setDisabled(true);
					}
					else {
						if(isNullOrEmpty(combo.getValue()[0])){
							var gradeaveragereportgrid = this.up('gradeaveragereportstructure').down('#gradeaveragereportgrid');
							gradeaveragereportgrid.down('#gradeAverageExportReport').setDisabled(true);
						}
						else {
							var gradeaveragereportgrid = this.up('gradeaveragereportstructure').down('#gradeaveragereportgrid');
							gradeaveragereportgrid.down('#gradeAverageExportReport').setDisabled(false);
						}
					}
				}
			}
		},{
       	 xtype: 'customcombobox',
         name: 'studentStatus',
         fieldLabel: getExaminationTranslation('STUDENT_STATUS'),
         value:true,
         width: 256,
         store: 'common.StatusComboStore',
         itemId: 'studentStatusId',
         valueField: 'value',
         displayField: 'name'
    }]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});
