/**
 * @author Manas
 */
Ext.define('Academia.view.examinationcenters.reports.GradeRosterReportSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.graderosterreportsearchform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[ {
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width: 256,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				beforerender : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStoreByBatchId');
					combo.bindStore(store)
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden : true,
			listeners  :{
				beforerender : function(combo){
					//var store=Ext.create('Academia.store.common.AcademicTermStore');
					var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			//store:'common.AllAccessibleCVByperiodAndCourseId',
			store:'examinationcenters.reports.ExaminationReportCourseStore',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			//width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'), 
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
        	xtype: 'customcombobox',
            name: 'courseVariant',
            itemId:'courseVariantItemId',
            store:'examinationcenters.reports.ExaminationReportCVStore',
//            store:'facilitiesresources.resourcebooking.CourseVariantsListStore',
            displayField:'value',
            queryParam:'name',
            valueField:'id',
            width: 256,
            minChars:3,
            typeAhead:false,
			forceSelection:true,
			disabled:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			},
            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
        },{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
//			store:'program.programDetails.programBatches.courseParameter.ProgramCourseByCourseIdStore',
			store:'examinationcenters.reports.ExamGradeReportProgramStore',
			//store:'common.FacultyAssignedActiveProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueSecondValue',
			queryParam:'name',
			minChars:3,
			//width: 536,
			//allowBlank:false,
			//typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			/*listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}*/
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 536
		},
		items:[{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'examinationcenters.reports.ExaminationReportBatchStore',
//			store:'common.BatchesByProgramId',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			disabled:true,
			//allowBlank:false,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			//store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			store:'examinationcenters.reports.ExaminationReportPeriodStore',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]	
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 536
		},
		items:[{
			xtype: 'customcombobox',
			name: 'facultyName',
			itemId: 'facultyItemId',
			//disabled:true,
			store:'coursetransaction.facultytopicassignment.AssignFacultyStore',
			fieldLabel:getExaminationTranslation('FACULTY'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'codeOrName',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'studentName',
			itemId: 'studentItemId',
			//disabled:true,
//			store:'coursetransaction.facultytopicassignment.StudentRosterFilter',
			store:'examinationcenters.reports.ExaminationReportStudentStore',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
			forceSelection:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
    		xtype: 'customcombobox',
			name:'studentStatus',
			itemId:'studentStatus',
			fieldLabel: getCommonTranslation('STATUS'),
			minChars:3,
			typeAhead:false,
			value:true,
			width: 256,
			valueField: 'value',
            displayField: 'name',
			forceSelection:true,
			store:'common.picklist.StudentActiveInactiveStatusStore',
			disabled:false,
    	}]
		},
		{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			//formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
