/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.GradeWiseReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.gradewisereportform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'gradeName',
				itemId:'gradeNameId',
				fieldLabel: getExaminationTranslation('GRADE_NAME'),
				store:'examinationcenters.reports.GradeNameStore',
				displayField:'value',
				valueField:'value',
				forceSelection:true,
				allowBlank:false,
			},{
				xtype: 'customcombobox',
				name: 'programCategory',
				itemId:'programCategoryId',
				fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
				store:'program.ProgramCategoryByGradeStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true
			}]}
		]},{
			xtype: 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width: 256,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStoreByBatchId');
						combo.bindStore(store)
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				hidden:true,
				forceSelection : true,
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.program.AcademicTermByProgramCategoryStore');
						combo.bindStore(store)
					}
				}
			}]
		},{   
				xtype:'fieldset',
				title: getTransportTranslation('MORE_FILTERS'),
				layout:'vbox',
				frame:true,	
				collapsible:true,
				collapsed:true,
				style:{marginTop: '35px!important',paddingTop:'18px!important'},
				width:'100%',
				itemId:'moreFilterId',
				items: [{
					xtype:'fieldcontainer',
					width:'100%',
					layout:'hbox',
					defaults:{
						labelAlign:'top',
						width: 256
					},
					items:[{
						xtype: 'customcombobox',
						name:'programId',
						itemId:'programItemId',
						store:'program.programDetails.programBatches.courseParameter.ProgramCourseByCourseIdStore',
						fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
						valueField: 'id',
						displayField: 'valueCode',
						queryParam:'programName',
						minChars:3,
						//width: 536,
						//typeAhead:false,
						triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
						forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR')
						/*listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}*/
					},{
						xtype: 'customcombobox',
						name:'batchId',
						itemId:'batchItemId',
						store:'feeandpayment.BatchSmartSearchStore',
						fieldLabel:getExaminationTranslation('BATCH'),
						valueField: 'id',
						displayField: 'value',
						width: 256,
						typeAhead:false,
						disabled:true,
						forceSelection:true,
						listConfig: {
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							},
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
						}
					},{
						xtype: 'customcombobox',
						name: 'periodId',
						itemId: 'periodItemId',
						store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
						fieldLabel:getExaminationTranslation('PERIOD'),
						valueField: 'id',
						displayField: 'value',
						width: 256,
						typeAhead:false,
						disabled:true,
						forceSelection:true,
						hidden:true,
						listConfig: {
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							},
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
						}
					}]
				},{
					xtype:'fieldcontainer',
					width:'100%',
					layout:'hbox',
					defaults:{
						labelAlign:'top',
						width: 256
					},
					items:[{
						xtype: 'customcombobox',
						name: 'courseId',
						itemId: 'courseItemId',
						store:'examinationcenters.reports.ExaminationReportCourseStore',
						fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
						valueField: 'id',
						displayField: 'value',
						queryParam:'name',
						minChars:3,
						//width: 536,
						typeAhead:false,
						triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
						forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						listConfig: {
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-iperiodIdtem">' +
								'{value}' +
								'</div>';
							},
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
						}
					},{
			        	xtype: 'customcombobox',
			            name: 'courseVariantId',
			            itemId:'courseVariantItemId',
			            store:'facilitiesresources.resourcebooking.CourseVariantsListStore',
			            displayField:'code',
			            queryParam:'courseName',
			            valueField:'id',
			            width: 256,
			            minChars:3,
			            typeAhead:false,
						forceSelection:true,
						disabled:true,
						listConfig: {
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code}' +
								'</div>';
							},
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
						},
			            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
			        }]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					width:'100%',
					defaults: {
						width: 536,
						labelAlign: 'top',
					},
					items:[{
						xtype: 'customcombobox',
						name: 'admissionId',
						itemId: 'admissionItemId',
						store:'examinationcenters.reports.GradeWiseStudentListStore',
						fieldLabel:getExaminationTranslation('ADMISSIONID_STUDENTID_STUDENTNAME'),
						valueField: 'id',
						displayField: 'value',
						queryParam:'studentName',
						enableKeyEvents  : 'true',
						minChars:3,
						typeAhead:false,
						forceSelection:true,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						triggerAction: 'all',
						hideTrigger:false,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code} / {value}'  +
								'</div>';
							}
						}
					},{
		            	 xtype: 'customcombobox',
		                 name: 'studentStatus',
		                 fieldLabel: getCommonTranslation('STATUS'),
		                 value:true,
		                 width: 256,
		                 store: 'common.StatusComboStore',
		                 itemId: 'studentStatusId',
		                 valueField: 'value',
                         forceSelection:true,
		                 displayField: 'name'
		            }]
				
				}],
		},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
