/**
 * @author Dharmendra.p
 */
Ext.define('Academia.view.examinationcenters.reports.MarksheetReportSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.marksheetreportsearchform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:'examinationcenters.reports.marksheet.MarksheetReportStudentStore',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
			name:'studentStatus',
			itemId:'studentStatus',
			fieldLabel: getCommonTranslation('STATUS'),
			minChars:3,
			typeAhead:false,
			value:true,
			 valueField: 'value',
             displayField: 'name',
			forceSelection:true,
			store:'common.picklist.StudentActiveInactiveStatusStore',
			disabled:false,
    	}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 536
		},
		items:[{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			width: 256,
			typeAhead:true,
			forceSelection:true,
			editable: false,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.examinationcenters.reports.marksheet.MarksheerReportIntakeYearStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			width: 256,
			typeAhead : true,
			editable: false,
			hidden:true,
			forceSelection : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.examinationcenters.reports.marksheet.MarksheetReportAcademicTermStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportProgramStore'),
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 256,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 536
		},
		items:[{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportBatchStore'),
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			disabled:true,
			allowBlank:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportPeriodStore'),
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			hidden:true,
		},{
			xtype: 'multiselectcombofield',
			name: 'sectionId',
			itemId: 'sectionItemId',
			disabled:true,
			store:'attendance.SectionAndFacultyByPeriodID',
			fieldLabel:getExaminationTranslation('SECTION'),
			valueField: 'sectionId',
			displayField: 'sectionCode',
			width: 256,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true
		}]	
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '35px!important',paddingTop:'18px!important'}, 
		width:'100%',
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'courseId',
				itemId: 'courseItemId',
				store:'examinationcenters.reports.marksheet.MarksheetReportCourseStore',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
	        	xtype: 'customcombobox',
	            name: 'courseVariant',
	            itemId:'courseVariantItemId',
	            store:'examinationcenters.reports.marksheet.MarksheetReportCourseVariantsListStore',
	            displayField:'value', 
	            queryParam:'courseName',
	            valueField:'id',
	            width: 256,
	            minChars:3,
	            typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
	            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
	        }]
		},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[]
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
