/**
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.examinationcenters.reports.PendingMarksRemarksReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.pendingmarksremarksreportform',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	items:[{

		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		itemId:'radioGroupContainer',
		defaults:{
			labelAlign:'top',
		},
		xtype:'panel',
		cls: 'panelNoSpace',
		style:{marginLeft:'-2px !important'},
		items:[{
			xtype: 'radiogroup',
			itemId:'radiogroupItemId',
			name:'radiogroupId',
			columns: 2,
			items: [
			        { boxLabel: getExaminationTranslation('MARK_ENTRY'), name: 'isMarkEntry', inputValue: true,checked:true},
			        { boxLabel: getExaminationTranslation('REMARKS'), name: 'isMarkEntry', inputValue: false}
			        ]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'marksheetJob',
			itemId:'marksheetJobNameId',
			store: 'examinationcenters.reports.MarksheetJobIdReportCombo',
			fieldLabel: getExaminationTranslation('MARKSHEET_JOB_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'jobName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			/**
			 * name and itemId for these fields should be marksheetSubLevelNameId, marksheetLevelNameItemId but due to old implementation, I am using old one.
			 * */
			name:'marksheetJobLevel',
			itemId:'marksheetJobLevelId',
			store: 'examinationcenters.marksheet.MarksheetLevelsCombo',
			fieldLabel: getExaminationTranslation('MARKSHEET_LEVEL_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'jobSubLevelName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
            xtype: 'groupingcombobox',
            name: 'evaluationLevel',
            itemId:'evaluationLevelId',
            labelAlign:'top',
            queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store: 'examinationcenters.reports.EvalListLevelPlanToMethodStore',
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            valueField: 'id' ,
            allowBlank: false,
            forceSelection: true/*,
            listeners:{
            	select:function(obj,rec){
            		var data=rec[0].data.code;
            		//obj.nextSibling().setValue(data);
            	}
            }*/
        }]
	},{
    	xtype: 'fieldcontainer',
    	width: '100%',
		layout : 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('INTAKE_YEAR'),
		name : 'intakeYear',
		itemId : 'intakeYear',
		displayField:'value',
		valueField:'id',
		width: 256,
		typeAhead:true,
		forceSelection:true,
		minChars:3,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}'  +
				'</div>';
			}
		},
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.common.IntakeYearStore');
				combo.bindStore(store)
			}
		}
	},{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
		name : 'academicTerm',
		itemId : 'academicTerm',
		displayField : 'value',
		queryParam:'qry',
		minChars:3,
		valueField : 'id',
		typeAhead : true,
		hidden:true,
		forceSelection : true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}'  +
				'</div>';
			}
		},
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
				combo.bindStore(store)
			}
		}
	},{
		xtype: 'customcombobox',
		name: 'evaluationType',
		itemId:'evaluationTypeItemId',
		store:'examCenter.AssignSequence.EvaluationType',
		displayField:'value',
		valueField:'id',
		forceSelection:true,
		editable:false,
		typeAhead:true,
		fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
	},]},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:'examinationcenters.reports.ExaminationReportProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueSecondValue',
			queryParam:'name',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'feeandpayment.BatchSmartSearchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			disabled:true,
			queryParam:'qry',
			minChars:3,
			//allowBlank:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:false,
			forceSelection:true,
			hidden:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}] 
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{ 
				    xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: '',
		            itemId:'pendingmarkentrycheckId',
		            boxLabel:getExaminationTranslation('PENDING_MARK_ENTRY_CHECK'),
		            name: 'pendingmarkentrycheckId',
		            inputValue : true, 
		            uncheckedValue: false,         
                    hidden:false,       
					disabled:false,
					style:{
			        		marginTop:'10px',
							paddingTop:'15px!important'
			        	  },      
						},
						{ 
				    xtype: 'checkboxfield',
		            width: 'auto',
		            labelAlign: '',
		            itemId:'remarkcheckId',
		            boxLabel:getExaminationTranslation('PENDING_REMARK_ENTRY_CHECK'),
		            name: 'remarkcheckId',
		            inputValue : true, 
		            uncheckedValue: false,         
                    hidden:true,       
					disabled:false,
					style:{
			        		marginTop:'10px',
							paddingTop:'15px!important'
			        	  },      
						}]
	},{
	xtype:'fieldset',
	title: getTransportTranslation('MORE_FILTERS'),
	layout:'vbox',
	frame:true,	
	collapsible:true,
	collapsed:true,
	style:{marginTop: '35px!important',paddingTop:'18px!important'},  //V2D-404199 
	width:'100%',
	itemId:'moreFilterId',
	items: [{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId: 'sectionItemId',
			store:'attendance.SectionAndFacultyByPeriodID',
			fieldLabel:getExaminationTranslation('SECTION'),
			valueField: 'sectionId',
			displayField: 'sectionCode',
			width: 256,
			typeAhead:false,
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'evaluationPlanId',
			itemId: 'evaluationPlanItemId',
			store:'examinationcenters.reports.ExaminationPlanStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{valueCode}' +
					'</div>';
				}
			}
		},{
    		xtype: 'customcombobox',
            name: 'evalPlanLevelNameId',
            itemId:'evalPlanLevelNameItemId',
    	    store:'examinationcenters.remark.EvaluationLevelForPendingMarksRemarkStore',
    	    displayField:'value',
    		valueField:'value',
    		forceSelection:true,
    		typeAhead:true,
    		minChars:3,
    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL_NAME'),
    		width: 256,
    		maxLength:1000000,
    		autoloadStore: false,
    		disabled:true
    	}]},{
	    	xtype: 'fieldcontainer',
	    	width: '100%',
			layout : 'hbox',
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
				xtype: 'customcombobox',
				name: 'courseId',
				itemId: 'courseItemId',
				store:'examinationcenters.reports.PendingMarksRemarksCourseStore',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'searchText',
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
	        	xtype: 'customcombobox',
	            name: 'courseVariantId',
	            itemId:'courseVariantItemId',
	            store:'facilitiesresources.resourcebooking.CourseVariantsListStore',
	            displayField:'code',
	            queryParam:'courseName',
	            valueField:'id',
	            width: 256,
	            minChars:3,
	            typeAhead:false,
				forceSelection:true,
				disabled:true,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				},
	            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
	        },{
        	xtype: 'hidden',
            name: 'evalPlanLevelType'
	        }
      ]},{
	    	xtype: 'fieldcontainer',
	    	width: '100%',
			layout : 'hbox',
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype: 'customcombobox',
	        	name: 'admissionId',
	        	itemId: 'admissionItemId',
	        	store:'examinationcenters.reports.PendingMarksRemarksStudentListStore',
	        	fieldLabel:getPersonModuleTranslation('STUDENT_ID_NAME'),
	        	valueField: 'id',
				displayField: 'value',
				queryParam:'studentName',
	        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	        	enableKeyEvents  : 'true',
	        	minChars:3,
	        	typeAhead:false,
	        	forceSelection:true,
	        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        	triggerAction: '',
	        	hideTrigger:false,
	        	maxLength: 250,
	        	listConfig: {
	        		listeners: {
	        			beforeshow: function(picker) {
	        				picker.minWidth = picker.up('combobox').getSize().width;
	        			}
	        		},
	        		loadingText: getCommonTranslation('SEARCHING'),
	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        		getInnerTpl: function() {
	        			return '<div class="search-item">' +
	        			'{studentCode} / {studentName}' +
	        			'</div>';
	        		}
	        	}
	        },{
	          	 xtype: 'customcombobox',
	             name: 'studentStatus',
	             itemId: 'studentStatusId',
	             fieldLabel: getCommonTranslation('STATUS'),
	             value:true,
	             width: 256,
	             store: 'common.StatusComboStore',
	             valueField: 'value',
	             displayField: 'name',
	             forceSelection:true,
	        }
      ]}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items:[{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				//buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]
}]});
