/**
 * @author ravindra
 */
Ext.define('Academia.view.examinationcenters.reports.PeriodLevelReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.periodlevelreportwin',
	title : getExaminationTranslation('PERIOD_LEVEL_REPORT'),
	modal: true,
	autoScroll:true,
	maxHeight:250,
	width: '15%',
	height:'20%',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
        		width: 256
			},
			items: [{
            	xtype: 'customcombobox',
            	itemId:'periodLevelReportFilterId',
        		name: 'periodLevelReportFilter',
        	    store:'setup.templatemapping.TemplateNameListFacultyByCode',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        		enableKeyEvents  : 'true',
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getCommonTranslation('REPORT_TYPE')
            }]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getExaminationTranslation("SUBMIT") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				buttonAlign: 'left',
				//margin: '5px 0px 0px 105px',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}]
		}]
	}]
});