/**
 * @Author Manas Luktuke
 */
var examStore = Ext.create('Academia.store.examinationcenters.reports.ReportbyFacultyStore')
Ext.define('Academia.view.examinationcenters.reports.ReportbyFacultyGrid', {
	title: getExaminationTranslation('REPORT_BY_FACULTY'),
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.reportbyfacultygrid',
	store: examStore,
	frame: false,
	border: true,
	enableColumnHide: true,
	itemId: 'reportbyfacultygrid',
	headerFix: {
		headerFix: true,
		portalIdsWithStructure: {
			'studentmarkentryreportform': 1
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: examStore,
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function () {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	columns: [{
		header: getCommonTranslation('USER_ID_HEADER'),
		dataIndex: 'userId',
		hidden: true,
		sortable: true,
		flex: 1
	}, {
		header: getCommonTranslation('USER_CODE'),
		text: 'User Code',
		dataIndex: 'userCode',
		hidden: false,
		sortable: true,
		flex: 1
	}, {
		header: getCommonTranslation('USER_NAME'),
		text: 'User Name',
		dataIndex: 'userName',
		hidden: false,
		sortable: true,
		flex: 1
	}, {
		header: getCommonTranslation('WHETHER_INTERNAL'),
		text: 'User Type',
		dataIndex: 'whetherInternal',
		hidden: true,
		sortable: true,
		flex: 1,
		renderer: function (value, meta, record) {
			return record.raw.whetherInternal;
		}
	}, {
		header: getCommonTranslation('USER_GROUP'),
		text: 'User group',
		dataIndex: 'userGroup',
		hidden: false,
		sortable: true,
		flex: 1
	}, {
		header: getCommonTranslation('ACADEMY_LOCATION_NAME'),
		text: 'Academy location',
		dataIndex: 'academyLocationName',
		hidden: false,
		sortable: true,
		flex: 1
	}, {
		header: getCommonTranslation('MARK_ENTRY_COUNT'),
		text: 'Mark Entry Count',
		dataIndex: 'markEntryCount',
		hidden: false,
		sortable: true,
		flex: 1,
		renderer: function (value, meta, record) {
			if (record.raw.markEntryCount) {
				return '<a href=#>' + record.raw.markEntryCount + '<a>';
			} else {
				return ""
			}
		}
	}, {
		header: getCommonTranslation('USER_STATUS'),
		text: 'User Status',
		dataIndex: 'userStatus',
		hidden: false,
		sortable: true,
		flex: 1,
		renderer: function (value, meta, record) {
			if (value) {
				return '<span style="color: green;">' + "Active" + '</span>';
			} else {
				return '<span style="color: red;">' + "Inactive" + '</span>';
			}
		}
	}]
});
