/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.examinationcenters.reports.faculty.FacultyPendingMarksFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.facultypendingmarksfilter',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
		}
	},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
			},
			xtype:'panel',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'radiogroupItemId',
				name:'radiogroupId',
				columns: 2,
				items: [
				        { boxLabel: getExaminationTranslation('MARK_ENTRY'), name: 'isMarkEntry', inputValue: true,checked:true},
				        { boxLabel: getExaminationTranslation('REMARKS'), name: 'isMarkEntry', inputValue: false}
				        ]
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'marksheetJob',
			itemId:'marksheetJobNameId',
			store: 'examinationcenters.reports.MarksheetJobIdReportCombo',
			fieldLabel: getExaminationTranslation('MARKSHEET_JOB_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'jobName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			/**
			 * name and itemId for these fields should be marksheetSubLevelNameId, marksheetLevelNameItemId but due to old implementation, I am using old one.
			 * */
			name:'marksheetJobLevel',
			itemId:'marksheetJobLevelId',
			store: 'examinationcenters.marksheet.MarksheetLevelsCombo',
			fieldLabel: getExaminationTranslation('MARKSHEET_LEVEL_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'jobSubLevelName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{

            xtype: 'groupingcombobox',
            name: 'evaluationLevel',
            itemId:'evaluationLevelId',
            labelAlign:'top',
            queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.reports.EvalListLevelPlanToMethodStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            valueField: 'id' ,
            allowBlank: false,
            forceSelection: true
		}]
	},{
    	xtype: 'fieldcontainer',
    	width: '100%',
		layout : 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('INTAKE_YEAR'),
		name : 'intakeYear',
		itemId : 'intakeYear',
		displayField:'value',
		valueField:'id',
		width: 256,
		typeAhead:true,
		forceSelection:true,
		minChars:3,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}'  +
				'</div>';
			}
		},
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.common.IntakeYearStore');
				combo.bindStore(store)
			}
		}
	},{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
		name : 'academicTerm',
		itemId : 'academicTerm',
		displayField : 'value',
		valueField : 'id',
		typeAhead : true,
//		hidden:true,
		forceSelection : true,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}'  +
				'</div>';
			}
		},
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
				combo.bindStore(store)
			}
		}
	},{
		xtype: 'customcombobox',
		name: 'evaluationType',
		itemId:'evaluationTypeItemId',
		store:'examCenter.AssignSequence.EvaluationType',
		displayField:'value',
		valueField:'id',
		forceSelection:true,
		editable:false,
		typeAhead:true,
		fieldLabel:getExaminationTranslation('EVALUATION_TYPE'),
	}]},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype : 'customcombobox',
			name : 'programId',
			itemId : 'programItemId',      	   
			store : 'examinationcenters.reports.ExaminationReportProgramStore',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField : 'id',
			displayField : 'valueSecondValue',
			typeAhead : true,
			forceSelection : true,
			queryParam:'name',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			//store:'common.BatchesByProgramId',   V2D-17057
			store:'common.CurrentBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			disabled:true,
			typeAhead:false,
			forceSelection:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width: 256,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '35px!important',
			paddingTop:'18px!important' },    
		width:'100%',
		itemId:'moreFilterId',
		items: [{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'customcombobox',
				name: 'sectionId',
				itemId: 'sectionItemId',
				store:'attendance.SectionAndFacultyByPeriodID',
				fieldLabel:getExaminationTranslation('SECTION'),
				valueField: 'sectionId',
				displayField: 'sectionCode',
				width: 256,
				typeAhead:false,
				forceSelection:true,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'evaluationPlanId',
				itemId: 'evaluationPlanItemId',
				store:'examinationcenters.reports.ExaminationPlanStore',
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width: 256,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{valueCode}' +
						'</div>';
					}
				}
			},
			{
	    		xtype: 'customcombobox',
	            name: 'evalPlanLevelNameId',
	            itemId:'evalPlanLevelNameItemId',
	    	    store:Ext.create('Academia.store.examinationcenters.remark.EvaluationLevelForPendingMarksRemarkStore'),
	    	    displayField:'value',
	    		valueField:'value',
	    		forceSelection:true,
	    		typeAhead:true,
	    		minChars:3,
	    		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL_NAME'),
	    		width: 256,
	    		maxLength:1000000,
	    		autoloadStore: false,
	    		disabled:true
	    	}]},{
		    	xtype: 'fieldcontainer',
		    	width: '100%',
				layout : 'hbox',
		        defaults: {
		            width: 256,
		            labelAlign: 'top'
		        },
		        items: [{
					xtype: 'customcombobox',
					name: 'courseId',
					itemId: 'courseItemId',
					store:'examinationcenters.reports.PendingMarksRemarksCourseStore',
					fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'searchText',
					minChars:3,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						},
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					}
				},{
					xtype: 'customcombobox',
					name: 'courseVariantId',
					itemId:'courseVariantItemId',
					store:'attendance.VariantMappedToPlan',
					displayField:'value',
					valueField:'id',
					width: 256,
					maxLength:9999,
					maxSelections :9999,
					forceSelection:true,
					typeAhead:true,
					editable:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
					},
					fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
					disabled:true
				}
	      ]},{
		    	xtype: 'fieldcontainer',
		    	width: '100%',
				layout : 'hbox',
		        defaults: {
		            width: 256,
		            labelAlign: 'top'
		        },
		        items: [{
		        	xtype: 'customcombobox',
		        	name: 'admissionId',
		        	itemId: 'admissionItemId',
		        	store:'examinationcenters.reports.PendingMarksRemarksStudentListStore',
		        	fieldLabel:getPersonModuleTranslation('STUDENT_ID_NAME'),
		        	valueField: 'id',
					displayField: 'value',
					queryParam:'studentName',
		        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		        	enableKeyEvents  : 'true',
		        	minChars:3,
		        	typeAhead:false,
		        	forceSelection:true,
		        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		        	triggerAction: '',
		        	hideTrigger:false,
		        	maxLength: 45,
		        	listConfig: {
		        		listeners: {
		        			beforeshow: function(picker) {
		        				picker.minWidth = picker.up('combobox').getSize().width;
		        			}
		        		},
		        		loadingText: getCommonTranslation('SEARCHING'),
		        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		        		getInnerTpl: function() {
		        			return '<div class="search-item">' +
		        			'{studentCode} / {studentName}' +
		        			'</div>';
		        		}
		        	}
		        },{
		          	 xtype: 'customcombobox',
		             name: 'studentStatus',
		             fieldLabel: getCommonTranslation('STATUS'),
		             value:true,
		             width: 256,
		             store: 'common.StatusComboStore',
		             itemId: 'studentStatusId',
		             valueField: 'value',
		             forceSelection:true, // V2D-460680     
		             displayField: 'name'
		        }
	      ]}]
			},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items:[{
				xtype : 'fieldcontainer',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'searchBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind : true
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'resetBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}]	
			}]
		}]
});
