/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.reports.updatedmarkremarkreport.UpdatedMarksRemarksReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.updatedmarksremarksreportfilter',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width: 256
	},
	items:[{

		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
			defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programIdItemId',
			store:'examinationcenters.reports.ReportProgramStore',
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportProgramStore'),
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  

		},{
			xtype: 'customcombobox',
			name: 'batchId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportBatchStore'),
			displayField:'value',
			valueField:'id',
			itemId:'batchIdItemId',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			fieldLabel: getExaminationTranslation('BATCH'),
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:Ext.create('Academia.store.examinationcenters.reports.ExamRankReportPeriodStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			itemId:'periodIdItemId',
			allowBlank: false
		}]
	},{

		xtype: 'fieldcontainer',
		layout: 'hbox',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{   
			xtype: 'customcombobox',
			name:'courseId',
			itemId:'courseItemId',
			store:'examinationcenters.reports.ExaminationSubjectLevelReportCourseStore',
			fieldLabel: getExaminationTranslation('COURSE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			//allowBlank: false,
			disabled : true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'courseVariant',
			itemId:'courseVariantItemId',
			store:Ext.create('Academia.store.facilitiesresources.resourcebooking.CourseVariantsListStore'),
			displayField:'code',
			queryParam:'courseName',
			valueField:'id',
			width: 256,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			fieldLabel:getExaminationTranslation('COURSE_VARIANT')

		}]

	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:Ext.create('Academia.store.examinationcenters.reports.ExaminationReportStudentStore'),
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			width: 536,
			typeAhead:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			width: 256,
			name:'studentStatus',
			itemId:'studentStatus',
			fieldLabel: getExaminationTranslation('STATUS'),
			typeAhead:false,
			value:true,
			valueField: 'value',
			displayField: 'name',
			forceSelection:true,
			store:'common.picklist.StudentActiveInactiveStatusStore',

		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items:[{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]
	}]});
