/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.reports.updatedmarkremarkreport.UpdatedMarksRemarksReportGrid',{ 
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.updatedmarksremarksreportgrid',
	store :  'examinationcenters.reports.updatedmarksremarks.UpdatedMarksRemarksGridStore',
	title :  getExaminationTranslation('UPDATED_MARKS_GRADE_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'examinationcenters.reports.updatedmarksremarks.UpdatedMarksRemarksGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
   },
   columns: [{
		header : getExaminationTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex : 1
	},
	{
		header : getExaminationTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : 1
	},
	{
		header : getExaminationTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1
	},{
		header : getExaminationTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1
	},{
		header : getExaminationTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1
	},{
		header : getExaminationTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1
	},{
		header :getExaminationTranslation('COURSE'),
		dataIndex : 'courseName',
		flex : 1
	},{
		header : getExaminationTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1
	},{
		header : getExaminationTranslation('EVENT'),
		dataIndex : 'eventName',
		flex : 1
	},{
		header : getExaminationTranslation('OBTAINED_MARKS'),
		dataIndex : 'obtainedMarks',
		flex : 1
	},{
		header : getExaminationTranslation('EFFECTIVE_MARKS'),
		dataIndex : 'effectiveMarks',
		flex : 1
	},{
		header : getExaminationTranslation('FINAL_MARKS_BY_TEACHER'),
		dataIndex : 'lastUpdateByUser',
		flex : 1
	},{
		header : getExaminationTranslation('REMARK'),
		dataIndex : 'finalDescription',
		flex : 1
	},{
		header : getExaminationTranslation('FINAL_UPDATE'),
		dataIndex : 'lastUpdateOn',
		flex : 1
	}]
});
