/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.examinationcenters.revaluation.RevaluationCoreErpStudentFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.revaluationcoreerpstudentfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit : false,
    plugins : "formlabelrequired",
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
        	width: 536,
            labelAlign: 'top'
        },
        items: [{
			xtype:'hidden',
			name:'isRevalFeeApplicable',
			itemId : 'isRevalFeeApplicable',
		},{
			xtype:'hidden',
			name:'isReviewFeeApplicable',
			itemId : 'isReviewFeeApplicable',
		},{
			xtype:'hidden',
			name:'isChallengeFeeApplicable',
			itemId : 'isChallengeFeeApplicable',
		},{
			xtype:'hidden',
			name:'revalFeePlanRuleStageId',
			itemId : 'revalFeePlanRuleStageId',
		},{
			xtype:'hidden',
			name:'reviewFeePlanRuleStageId',
			itemId : 'reviewFeePlanRuleStageId',
		},{
			xtype:'hidden',
			name:'challengeFeePlanRuleStageId',
			itemId : 'challengeFeePlanRuleStageId',
		},{
			xtype:'hidden',
			name:'revalFeeAmount',
			itemId : 'revalFeeAmount',
		},{
			xtype:'hidden',
			name:'reviewFeeAmount',
			itemId : 'reviewFeeAmount',
		},{
			xtype:'hidden',
			name:'challengeFeeAmount',
			itemId : 'challengeFeeAmount',
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			//typeAhead : true,
			queryMode: 'local',
			//minChars:'3',
			width:230,
			forceSelection : true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			store:'examinationcenters.revaluation.RevaluationCourseStore',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
		//	queryMode: 'local',
			minChars:3,
			width:348,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width: 256
		},
		items:[{
			xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentItemId',
			store:'examinationcenters.revaluation.RevaluationStudentListStore',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'studentName',
			minChars:3,
			width: 536,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programIdQuickFilter',
			store:'examinationcenters.revaluation.RevaluationAccessibleProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'programName',
	//		queryMode: 'local',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			allowBlank:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchIdQuickFilter',
			store:'examinationcenters.revaluation.RevaluationBatchStore',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			disabled:true,
			queryMode: 'local',
			minChars:'3',
			allowBlank:false,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('BATCH')
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdQuickFilter',
			store:'examinationcenters.revaluation.RevaluationPeriodStore',
			displayField:'value',
			valueField:'id',
			disabled:true,
			queryMode: 'local',
			minChars:'3',
			typeAhead:true,
			allowBlank:false,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('PERIOD')
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important',paddingTop:'25px!important'},
		width:'100%',
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width: 256,
			},
			items:[{
				xtype: 'customcombobox',
				name:'revaluationTypeEnum',
				itemId:'revaluationTypeEnum',
				store:'examCenter.AssignSequence.RevaluationTypeStore',
				valueField : 'value',
				forceSelection:true,
				editable:false,
				typeAhead:false,
				fieldLabel:getExaminationTranslation('REVALUATION_TYPE'),
				displayField : 'value',
				listConfig: { 
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'revaluationStatus',
				itemId: 'revaluationStatus',
				store:'examinationcenters.studentportal.revaluation.RevaluationStatusStore',
				fieldLabel:getExaminationTranslation('REVALUATION_STATUS'),
				valueField: 'name',
				displayField: 'value',
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
			},{
				xtype: 'customcombobox',
				name: 'revaluationApprovalStatus',
				itemId: 'revaluationApprovalStatus',
				store:'examinationcenters.studentportal.revaluation.RevaluationApprovalStatusStore',
				fieldLabel:getExaminationTranslation('APPROVAL_STATUS'),
				valueField: 'name',
				displayField: 'value',
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
			}]

		},{
			xtype : 'fieldcontainer',
			width: '100%',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items: [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getCommonTranslation('APPLIED_DATE')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{
				xtype : 'fieldcontainer',
				width: '100%',
				layout:'hbox',
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				items : [{
					xtype: 'datefield',
					name: 'fromdate',
					itemId: 'fromdate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'tilldate',
					editable:false,
					fieldLabel:getExaminationTranslation('FROM_DATE')
				},{

					xtype: 'datefield',
					name: 'tilldate',
					itemId: 'tilldate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'fromdate',
					editable:false,
					fieldLabel:getExaminationTranslation('TILL_DATE')				
			  }]
			}
			]},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items:[]
		}]
	},{
	    xtype: 'fieldcontainer',
        width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
        items: [ {
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        },{
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]
});