/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.revaluation.RevaluationSearchFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.revaluationsearchfilter',
	//autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'revaluationName',
			itemId:'revaluationNameItemId',
			store:'examinationcenters.revaluation.RevaluationNameCodeStore',
			valueField: 'id',
			displayField: 'valueCode',
			forceSelection:true,
			enableKeyEvents  : 'true',
			typeAhead:true,
			fieldLabel:getExaminationTranslation('REVALUATION_CODE_NAME'),
	 //   	queryMode: 'local', 	
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    hideTrigger:false,
		    queryParam:'revaluationName',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'revaluationTypeEnum',
			itemId:'revaluationTypeEnum',
			store:'examCenter.AssignSequence.RevaluationTypeStore',
	//		valueField : 'value',
			valueField : 'id',
			forceSelection:true,
			typeAhead:true,
			queryMode:'local',
			minChars:3,
			fieldLabel:getExaminationTranslation('REVAL_TYPE'),
			displayField : 'value',
			listConfig: { 
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	},{

		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programIdQuickFilter',
			store:'examinationcenters.revaluation.RevaluationProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'programName',
			disabled:true,
			queryMode: 'local',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchIdQuickFilter',
			store:'examinationcenters.revaluation.RevaluationBatchStore',
			displayField:'value',
			hideTrigger:false,
			forceSelection:true,
			valueField:'id',
			typeAhead:true,
			disabled:true,
			queryMode: 'local',
			minChars:'3',
			fieldLabel:getExaminationTranslation('BATCH')
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdQuickFilter',
			store:'examinationcenters.revaluation.RevaluationPeriodStore',
			displayField:'value',
			valueField:'id',
			disabled:true,
			typeAhead:true,
			queryMode: 'local',
			minChars:'3',
			hideTrigger:false,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('PERIOD')
		}]
	},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items: [{

				xtype: 'datefield',
				name: 'fromdate',
				itemId: 'fromdate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				endDateField: 'tilldate',
				editable:false,
				fieldLabel:getExaminationTranslation('FROM_DATE')
			},{

				xtype: 'datefield',
				name: 'tilldate',
				itemId: 'tilldate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				vtype: 'daterange',
				startDateField: 'fromdate',
				editable:false,
				fieldLabel:getExaminationTranslation('TILL_DATE')				
			}]
		},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'quickSearchId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

//}]
});