/**
 * @author bhanu ps
 */
Ext.define('Academia.view.examinationcenters.roomallocation.MappedStudentAllocationGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.mappedstudentallocationgrid',
	store: 'examinationcenters.roomallocation.RoomAllocationForBookedStatus',
	title: getExaminationTranslation('MAP_STUDENT_LIST'),
	border: true,
	autoScroll: false,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.roomallocation.RoomAllocationForBookedStatus',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	 tbar: [{
	        xtype: 'button',
	        itemId: 'searchResultGridBtnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    },{	
			xtype:'fieldcontainer',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
			},
			items:[{
				xtype:'textfield',
				emptyText: getExaminationTranslation('AUTO_SEARCH_STUDENT_MAPPING'),
				width: 360,
				name:'filedSearch',
				itemId:'fieldSearchItemId',
				cls: 'SearchTextFieldWithSmallHeader'
			}]
		}],
	columns: [{
		header:  getExaminationTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.1,
		sortable:true
	},{
		header:getExaminationTranslation("COURSE"),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true,
	},{
		header: getExaminationTranslation('CENTER'),
		dataIndex: 'centerName',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation('DATES'),
		dataIndex: 'scheduleDate',
		flex:.1,
		sortable:true,
        renderer:function(value){
        	return dateRender(value);
        }
	},{
		header:getExaminationTranslation('TIME_SLOT'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true,
		renderer:function(value, record){
        	return timeRender(record.record.data.timeFrom)+" - "+(timeRender(record.record.data.timeTo));
        }
	},{
		header:getExaminationTranslation('ROOM_NO'),
		dataIndex: 'roomNo',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation('STUDENT_NAME'),
		dataIndex: 'studentDisplayValue',
		flex:.1,
		sortable:true,
	},{
		header: getExaminationTranslation('HALL_TICKET'),
		dataIndex: 'hallTicket',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation('BOOKING_STATUS'),
		dataIndex: 'bookingStatus',
		flex:.1,
		sortable:true,
	}]
});
