/**
 * @author bhanu ps
 */
var RoomAllocationGrid =Ext.create('Academia.store.examinationcenters.roomallocation.RoomAllocationGrid');
Ext.define('Academia.view.examinationcenters.roomallocation.RoomAllocationGrid', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.roomallocationgrid',
	store: RoomAllocationGrid,
	title: getCommonTranslation('ROOMALLOCATION_LIST'),
	border: true,
	frame:false,
//	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [{
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : RoomAllocationGrid,
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	isGridConfigurable: true,
	enableColumnHide: false,
	initComponent: function() {

		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	 tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    },{
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    },{
			xtype : 'splitbutton',
			itemId:'spBtnMoreActions',
			text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
			menu:[{
				text:getExaminationTranslation('MAP_STUDENTS'),
				itemId:'mapStudentId'	
			},{
				text:getExaminationTranslation('ASSIGN_INVIGILATOR'),
				itemId:'assignInvigilatorId'
			},{
				text:getExaminationTranslation('PRINT_TIME_TABLE'),
				itemId:'printTimeTable'
			}]
		}],
	columns: [/*{
		header:  getExaminationTranslation('ID'),
		dataIndex: 'evaluationGroupId',
		flex:.1,
		hidden:true,
		sortable:true
	},*/{
		header:  getCommonTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation("COURSE"),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true
	},{
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('EVAL_DETAILED_SEQUENCE'),
		dataIndex: 'eventName',
		flex:.1,
		sortable:true
	},{
		header: getCommonTranslation('CENTER'),
		dataIndex: 'centerName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('DATES'),
		dataIndex: 'scheduleDateStr',
		flex:.1,
		sortable:true,
		renderer: function(date) {
            return date;
        }
	},{
		header:getCommonTranslation('TIME_SLOT'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true,
		renderer:function(value, record){
        	return (record.record.data.timeFromStr)+" - "+(record.record.data.timeToStr);
        }
	},{
		header:getCommonTranslation('ROOM_NO'),
		dataIndex: 'roomNo',
		flex:.1,
		sortable:true,
	},{
		header:getCommonTranslation('BOOKED'),
		dataIndex: 'bookedSeats',
		flex:.1,
		sortable:true,
//		renderer:function(value,meta,record){
//			if(!isNullOrEmpty(value)) {
//				if(value){
//					return "<span style=\'color:green\'>Yes</span>";
//				} else {
//					return "<span style=\'color:red\'>No</span>";
//				}
//			}
//		}
	},{
		header:getExaminationTranslation('AVAILABLE_SEATES'),
		dataIndex: 'balanceSeatForAllocateStudent',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('INVIGILATOR'),
		dataIndex: 'invigilators',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value.length==1){
					return value[0].value;
				} else if(value.length==0){
					return "<span style=\'color:red\'>Pending</span>";
				}else {
					return "<a href=#>View / Edit</a>";
				}
			}
		}
	}]
});
