/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.examinationcenters.roomallocation.RoomAllocationQuickFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.roomallocationquickfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchInnerPanel',
	method : 'POST',
	standardSubmit : false,
	items:[{
		xtype: 'fieldcontainer',
		itemId:'evalCoursePanelId',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'evalGroup',
			itemId: 'evalGroupId',
			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
//			store:'examinationcenters.reports.EvaluationGroupStore',  // for V2D-134877
			store:'examinationcenters.examstaffallocation.commonFilter.ExamGroupFilter',
			valueField: 'id',
  			displayField: 'value',
  			queryParam:'textSearch',
  			allowBlank:false,
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			autoSelect: false,
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}  
		},{
			xtype: 'customcombobox',
			name: 'centerName',
			itemId: 'centerNameId',
			fieldLabel:getExaminationTranslation('CENTER_NAME'),
//			store:'examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter',
			valueField: 'id',
  			displayField: 'valueCode',
  			queryParam:'textSearch',
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			allowBlank:false,
  			disabled:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{valueCode}' +
  					'</div>';
  				}
  			},
  			listeners: {
  				render : function(combo){
  					var store=Ext.create('Academia.store.examinationcenters.examstaffallocation.commonFilter.ExamCenterFilter');
  					combo.bindStore(store)
  				}
  			}
		}, {
			xtype: 'datefield',
			name: 'date',
			itemId:'dateItemId',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable:false,
			disabled:true,
			fieldLabel:getExaminationTranslation('DATE'),
		}/*,{
			xtype: 'customcombobox',
			name: 'date',
			itemId:'dateItemId',
			fieldLabel:getExaminationTranslation('DATE'),
			store:'examinationcenters.examstaffallocation.commonFilter.ExamDateFilter',
			valueField: 'id',
  			displayField: 'value',
  			queryParam:'textSearch',
  			disabled:true,
  			minChars:3,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		}*/]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'timeSlot',
			itemId:'timeSlotItemId',
			fieldLabel:getExaminationTranslation('TIME_SLOT'),
			store:'examinationcenters.examstaffallocation.commonFilter.ExamBatchFilter',
			valueField: 'id',
  			displayField: 'value',
  			queryParam:'textSearch',
  			minChars:3,
  			disabled:true,
  			typeAhead:false,
  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			listConfig: {
  				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				}
  			}
		},{
			xtype: 'customcombobox',
			name: 'roomNo',
			fieldLabel:getExaminationTranslation('ROOM_NO'),
			store:'examinationcenters.examstaffallocation.commonFilter.FindAllRoomNo',
			displayField:'valueCode',
			valueField:'id',
			disabled:true,
//			hidden:true,
			forceSelection:true,
			typeAhead:true,
//			disabled:true
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
                xtype: 'fieldcontainer',
                width: 'auto',
                layout: 'hbox',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
                	xtype: 'customcombobox',
          			name:'programId',
          			itemId:'programIdQuickFiltr',
          			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramFilter',
          			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
          			valueField: 'id',
          			disabled:true,
          			displayField: 'valueCode',
          			queryParam:'textSearch',
          			minChars:3,
          			width: 536,
          			typeAhead:false,
          			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
          			enableKeyEvents  : 'true',
          			hideTrigger:false,
          			forceSelection:true,
          			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
          			listConfig: {
          				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
          				loadingText: getCommonTranslation('SEARCHING'),
          				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
          				getInnerTpl: function() {
          					return '<div class="search-item">' +
          					'{value}' +
          					'</div>';
          				}
          			}  
                  },{
                  		xtype: 'customcombobox',
                  		name: 'batchId',
                     	itemId:'batchIdQuickFiltr',
            			store:'examinationcenters.examstaffallocation.commonFilter.ExamProgramBatchFilter',
            			fieldLabel:getExaminationTranslation('BATCH'),
            			valueField: 'id',
            			displayField: 'value',
            			queryParam:'textSearch',
            			minChars:3,
            			typeAhead:false,
            			disabled:true,
            			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            			enableKeyEvents  : 'true',
            			hideTrigger:false,
            			forceSelection:true,
//            			hidden:true,
            			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            			listConfig: {
            				listeners: {
          					beforeshow: function(picker) {
          						picker.minWidth = picker.up('combobox').getSize().width;
          					}
          				 },
            				loadingText: getCommonTranslation('SEARCHING'),
            				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            				getInnerTpl: function() {
            					return '<div class="search-item">' +
            					'{value}' +
            					'</div>';
            				}
            			} 
                  }]
		},{
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
            	xtype: 'customcombobox',
        		name: 'periodId',
        		itemId: 'periodItemId',
    			store:'examinationcenters.examstaffallocation.commonFilter.ExamPeriodFilter',
    			fieldLabel:getExaminationTranslation('PERIOD'),
    			valueField: 'id',
    			disabled:true,
    			displayField: 'value',
    			queryParam:'textSearch',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
//    			hidden:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
  					beforeshow: function(picker) {
  						picker.minWidth = picker.up('combobox').getSize().width;
  					}
  				 },
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			} 
          },{
          	xtype: 'customcombobox',
    		name: 'courseId',
    		itemId: 'courseItemId',
			store:'examinationcenters.examstaffallocation.commonFilter.ExamCourseFilter',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			queryParam:'textSearch',
			minChars:3,
			typeAhead:false,
			width: 536,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
//			hidden:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				 },
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			} 
         }]
        	}]
  	},{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout : {
			type : 'hbox'
		},
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			margin: '0 16 0 0'
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});