/**
 * Abhishek.Bais
 */

Ext.define('Academia.view.examinationcenters.thesisManagement.EditThesisManagementFormWin',
		{
	extend : 'Ext.window.Window',
	alias : 'widget.editthesismanagementformwin',
	title : getCommonTranslation('NOMINATE_STUDENT'),
	modal : true,
	maxHeight : 550,
	autoScroll : true,
	items : [ {
		xtype : 'dynamicfieldformwin',
		method : 'POST',
		itemId : 'thesismanagementItemId',
		autoScroll : true,
		margin : 0,
		// bodyPadding: '10 10 10 10',
		layout : {
			type : 'vbox'
		},
		defaults : {
			labelAlign : 'top'
		},
		standardSubmit : false,
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width : 235
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'hidden',
				name : 'id',
				itemId:'thesisManagementId',
			},{
				xtype : 'hidden',
				name : 'thesisManagementStatusId',
				itemId:'thesisManagementStatusId',
			},
			{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
					name : 'academicTerm',
					itemId : 'academicTermId',
					displayField : 'value',
					valueField : 'id',
					typeAhead : false,
					forceSelection : true,
					hidden: false,
					allowBlank: false,
					store: Ext.create('Academia.store.common.AcademicTermByMappedPeriodStore'),
					editable:false
				},{

					xtype: 'multiselectcombofield',
	                name: 'programGroup',
	                itemId:'programGroup',
					fieldLabel:  getCommonTranslation('PROGRAM_GROUP'),
					 displayField:'value',
		                valueField:'id',
					disabled:true,
					 store:Ext.create('Academia.store.program.ProgramGroupStore'),
					queryParam: 'programGrpName',
					labelAlign:'top',
					triggerAction: 'all',
					minChars:3,
					allowBlank:false,
					typeAhead:true,
					forceSelection: true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}
				}]
		},{
			xtype : 'fieldcontainer',
			itemId:'programBatch_Id',
			// width : '100%',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 235,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'admission',
				itemId: 'admissionId',
				store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
				fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				allowBlank: false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				},
				labelStyle:'font-size:12px !important'
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
				name : 'programId',
				itemId : 'programId',
				store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				displayField:'valueCode',
				valueField:'id',
				width:235,
				typeAhead:true,
				forceSelection:true,
				allowBlank: false,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			}, {
				xtype : 'hidden',
				name : 'period',
				itemId:'periodId',
			}]
		},{
			xtype : 'fieldcontainer',
			itemId:'programBatch',
			// width : '100%',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 235,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				allowBlank: false,
				store: Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				editable:false
			},{
				xtype: 'customcombobox',
				name: 'graduationCeremony',
				fieldLabel : getCommonTranslation('GRADUATION_CEREMONY'),
				itemId:'graduationCeremonyId',
				readOnly:true
			}]
		},{
        	xtype: 'datefield',
			name: 'ceremonyDate',
			itemId: 'ceremonyDate',
			width : 235,
			fieldLabel: getCommonTranslation('CEREMONY_DATE'),
			readOnly:true,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		
		},{
			xtype : 'fieldcontainer',
			fieldLabel: getCommonTranslation('SUPERVISOR_ID_NAME')+': <font color=red>*</font>',
			itemId:'superVisorfieldcontainerId',
			layout : 'hbox',
			labelSeparator:'',
			
			defaults : {
				labelAlign : 'top',
				width:'235'
			},
			items:[{
				xtype:'panel',
				itemId:'panelIdH',
				style:{
					'margin-left': '0px',
					'margin-top': '0px',
					'top':'0px'
				},
				items:[{
					xtype : 'fieldcontainer',
					layout : 'hbox',
					defaults : {
						labelAlign : 'top',
						width:'235'
					},

					items:[{
						xtype: 'customcombobox',
						width: 235,
						name: 'superVisor',
						itemId:'superVisorId',
						store: 'common.NominateStudentThesisStore',
						valueField: 'id',
						displayField: 'value',
						queryParam:'codeOrName',
						allowBlank: false,
						typeAhead: false,
						rowIndx:0,
						minChars:3,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						forceSelection:true,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
									picker.maxWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{value}' +
								'</div>';
							}
						}
					},{
						xtype: 'hidden',
						name: 'thesisManagementSupervisorId',
						itemId:'thesisManagementSupervisorId'
					},
					{
						xtype: 'button',
						itemId: 'addDetailedBtn',
						name: 'addDetailedBtn',
						width: 'auto',
						cls: 'CustomBodyBtnSettings mtAddRow',
						width: 'auto',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'3px'
						}
					}]
				}]
			}]}
		,{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 235,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'thesisManagementDrool',
				itemId:'thesisManagementDroolId',
				fieldLabel : getCommonTranslation('DROOLS'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				editable:false
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 235,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textarea',
				name: 'remarks',
				itemId:'remarksId',
				fieldLabel: getCommonTranslation('REMARKS'),
				width:480,
				maxLength:1000,
				style:{
					marginBottom:'100px'
				}

			}]
		},{
			xtype : 'fieldcontainer',
			width:'auto',
			items : [
				{
					xtype : 'button',
					action : 'Submit',
					text : getCourseTxCommonTranslation('SAVE'),
					formBind : true,
					itemId : 'SubmitBtn',
					ui : 'CustomBtnSubmit',
					scale : CONSTANTS.BUTTONSIZE
				},
				{
					xtype : 'button',
					text : getCourseTxCommonTranslation('CANCEL'),
					ui : 'CustomBtnCancel',
					itemId : 'CancelBtn',
					scale : CONSTANTS.BUTTONSIZE
				} ]
		}]
	}]
		});