/**
 * Raghavendra.Soni
 */
Ext.define('Academia.view.examinationcenters.thesisManagement.FacultyThesisManagementApproveRejectWin', {
	extend : 'Ext.window.Window',
	alias : 'widget.facultythesismanagementapproverejectwin',
	title : getCommonTranslation('ACCEPT_REJECT_THESIS'),
	modal : true,
	height:300,
	maxHeight : 300,
	autoScroll : true,
	items : [ {
		xtype : 'dynamicfieldformwin',
		method : 'POST',
		itemId : 'thesismanagementapproverejectwinItemId',
		autoScroll : true,
		margin : 0,
		layout : {
			type : 'vbox'
		},
		defaults : {
			labelAlign : 'top'
		},
		standardSubmit : false,
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width: 536
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'customcombobox',
				width: 536,
				fieldLabel: getCommonTranslation('APPROVAL_STATUS'),
				store:Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisStatusEnumStore'),
				name:'thesisStatus',
				itemId: 'thesisStatus',
				displayField: 'value',
				valueField: 'value',
				forceSelection:true,
				queryMode:'local',
				allowBlank: false,
				typeAhead : false,
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width: 536
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'customcombobox',
				width: 536,
				fieldLabel: getProgramandcourseTranslation('ACCESS_MODE'),
				store:Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementAccessModeStore'),
				name:'accessMode',
				itemId: 'accessMode',
				displayField: 'code',
				valueField: 'id',
				forceSelection:true,
				hidden:true,
				allowBlank: false,
				typeAhead : false,
			}]
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width: 536
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('DATE'),
				name : 'accessModeDate',
				itemId : 'accessModeDate',
				vtype : 'daterange',
				hidden:true,
				minValue:new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype : 'panel',
			itemId: 'acceptDocumentPanel',
			hidden:true,
			layout: 'vbox',
			flex: 1,
			width: 536,
			margin:0,
			title: getCommonTranslation('DOCUMENTS'),
			border: true,
			height: '250',
			autoScroll:true,
			items: [{
				xtype : 'panel',
				itemId: 'acceptDocuementPanelMenuView',
				width: '100%',
				padding:0,
				margin:0,
				border: false,
				height: 40,
				autoScroll:false,
				tbar: [
					{
						xtype: 'button',
						itemId: 'btnAcceptDocumentAddImage',
						tooltip: getCommonTranslation('ADD'),
						glyph: ICONGLYPH.ADDGLYPH
					},
					{
						xtype: 'button',
						itemId: 'btnAcceptDocumentDeleteImage',
						cls: 'CustomToolbarBtnReject',
						tooltip: getCommonTranslation('DELETE'),
						glyph: ICONGLYPH.DELETEGLYPH,
						disabled: true
					}
					]
			},{
				xtype : 'panel',
				itemId: 'AcceptDocumentDVPanel',
				flex: 1,
				width: '100%',
				padding:0,
				margin:0,
				height:210,
				autoScroll:true,
				items:[{
					xtype:'dataview',
					store: Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementDocumentStore'),
					tpl: new Ext.XTemplate(
							'<tpl for=".">',
							'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
							'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
							'<tpl else>',
							'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="Double click to download file">',
							'</tpl>',
							'<img src="{iconImage}" />',
							'<br/><span>{imageName}</span>',
							'<div><input type="checkbox" value="{documentId}" name="thesisImageId" onclick="facultyThesisManagementApproveRejectSelectionChange();" /></div>',
							'</div>',
							'</tpl>'
					),
					itemSelector: 'div.gallery-thumb-wrap',
					emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
					itemId: 'acceptDocumentDataView',
					height: '90%',
					deferEmptyText: false,
					style: {
						marginTop: '15px'
					},
					listeners: {
						itemclick: function( dataview, record, item, index, e, eOpts ){
							if(!isNullOrEmpty(record.data.fileType)){
								var extension = record.data.fileType.toLowerCase();
								if(extension == "png" || extension == "jpeg" || extension == "gif" || extension == "jpg"){
									//me.openImage(dataview, record, item, index, e, eOpts);
								}
							}
						},
						itemdblclick: function(dataview, record, item, index, e, eOpts ){
							var extension = record.data.fileType.toLowerCase();
							if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
								|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
									|| extension == "txt" || extension == "odt"){
								//me.downloadDocumentFile(record.data.id);
							}
						}
					}
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 536,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textarea',
				name: 'remarks',
				itemId:'remarksId',
				fieldLabel: getCommonTranslation('REMARKS'),
				width: 536,
				maxLength:1000

			}]
		},{
			xtype : 'fieldcontainer',
			cls : 'windowBtnPos',
			items : [
				{
					xtype : 'button',
					action : 'Submit',
					text : getCourseTxCommonTranslation('SAVE'),
					formBind : true,
					itemId : 'SubmitBtn',
					ui : 'CustomBtnSubmit',
					scale : CONSTANTS.BUTTONSIZE
				},
				{
					xtype : 'button',
					text : getCourseTxCommonTranslation('CANCEL'),
					ui : 'CustomBtnCancel',
					itemId : 'CancelBtn',
					scale : CONSTANTS.BUTTONSIZE
				} ]
		}]
	}]
});