/**
 * Raghavendra.Soni
 **/
Ext.define('Academia.view.examinationcenters.thesisManagement.FacultyThesisManagementSubmitDocumentWindow', {
	extend : 'Ext.window.Window',
	alias: 'widget.facultythesismanagementsubmitdocumentwindow',
	title : getCommonTranslation('THESIS_DOCUMENT'),
	autoScroll : true,
	width: 400,
	height : 600,
	maxHeight : 600,
	modal : true,
	layout: 'vbox',
	padding:0,
	margin:0,
	bodyStyle:{
		padding:'0 !important'
	},
	items : [{
		xtype : 'panel',
		itemId: 'thesisDocumentPanel',
		layout: 'vbox',
		flex: 1,
		width: 390,
		title: getCommonTranslation('THESIS_DOCUMENT'),
		border: true,
		height: 250,
		autoScroll:true,
		padding:0,
		margin:5,
		items: [{
			xtype : 'panel',
			itemId: 'thesisDocuementPanelMenuView',
			width: '100%',
			padding:0,
			margin:0,
			border: false,
			height: 40,
			autoScroll:false,
			tbar: [
				{
					xtype: 'button',
					itemId: 'btnThesisDocumentAddImage',
					tooltip: getCommonTranslation('ADD'),
					glyph: ICONGLYPH.ADDGLYPH
				},
				{
					xtype: 'button',
					itemId: 'btnThesisDocumentDeleteImage',
					cls: 'CustomToolbarBtnReject',
					tooltip: getCommonTranslation('DELETE'),
					glyph: ICONGLYPH.DELETEGLYPH,
					disabled: true
				}
			]
		},{
			xtype : 'panel',
			itemId: 'thesisDocumentDVPanel',
			flex: 1,
			width: '100%',
			height: '100%',
			padding:0,
			margin:0,
			autoScroll:true,
			items:[{
				xtype:'dataview',
				store: Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementDocumentStore'),
			    tpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<tpl else>',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="">',
						'</tpl>',
						'<img src="{iconImage}" />',
						'<br/><span>{imageName}</span>',
						'<div><input type="checkbox" value="{documentId}" name="thesisDocumentDataViewImage" onclick="facultyThesisDocumentSelectionChange(\'thesisDocumentDataViewImage\',\'btnThesisDocumentDeleteImage\');" /></div>',
						'</div>',
						'</tpl>'
				),
			    itemSelector: 'div.gallery-thumb-wrap',
			    emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
			    itemId: 'thesisDocumentDataView',
				height: '90%',
				deferEmptyText: false,
				style: {
		            marginTop: '15px'
		        },
				listeners: {
					itemclick: function( dataview, record, item, index, e, eOpts ){
						if(!isNullOrEmpty(record.data.fileType)){
							var extension = record.data.fileType.toLowerCase();
							if(extension == "png" || extension == "jpeg" || extension == "gif" || extension == "jpg"){
								//me.openImage(dataview, record, item, index, e, eOpts);
							}
						}
					},
					itemdblclick: function(dataview, record, item, index, e, eOpts ){
						var extension = record.data.fileType.toLowerCase();
						if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
							|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
								|| extension == "txt" || extension == "odt"){
							//me.downloadDocumentFile(record.data.id);
						}
					}
				}
			}]
		}]
	}, {
		xtype : 'panel',
		itemId: 'otherDocumentPanel',
		layout: 'vbox',
		flex: 1,
		width: 390,
		title: getCommonTranslation('OTHER_DOCUMENTS'),
		border: true,
		height: '250',
		autoScroll:true,
		padding:0,
		margin:5,
		items: [{
			xtype : 'panel',
			itemId: 'otherDocuementPanelMenuView',
			width: '100%',
			padding:0,
			margin:0,
			border: false,
			height: 40,
			autoScroll:false,
			tbar: [
				{
					xtype: 'button',
					itemId: 'btnOtherDocumentAddImage',
					tooltip: getCommonTranslation('ADD'),
					glyph: ICONGLYPH.ADDGLYPH
				},
				{
					xtype: 'button',
					itemId: 'btnOtherDocumentDeleteImage',
					cls: 'CustomToolbarBtnReject',
					tooltip: getCommonTranslation('DELETE'),
					glyph: ICONGLYPH.DELETEGLYPH,
					disabled: true
				}
			]
		},{
			xtype : 'panel',
			itemId: 'OtherDocumentDVPanel',
			flex: 1,
			width: '100%',
			height: '100%',
			padding:0,
			margin:0,
			autoScroll:true,
			items:[{
				xtype:'dataview',
				store: Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementDocumentStore'),
			    tpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<tpl if="fileType == &quot;png&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<tpl else>',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="">',
						'</tpl>',
						'<img src="{iconImage}" />',
						'<br/><span>{imageName}</span>',
						'<div><input type="checkbox" value="{documentId}" name="otherDocumentDataViewImage" onclick="facultyThesisDocumentSelectionChange(\'otherDocumentDataViewImage\',\'btnOtherDocumentDeleteImage\');" /></div>',
						'</div>',
						'</tpl>'
				),
			    itemSelector: 'div.gallery-thumb-wrap',
			    emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
			    itemId: 'otherDocumentDataView',
				height: '90%',
				deferEmptyText: false,
				style: {
		            marginTop: '15px'
		        },
				listeners: {
					itemclick: function( dataview, record, item, index, e, eOpts ){
						if(!isNullOrEmpty(record.data.fileType)){
							var extension = record.data.fileType.toLowerCase();
							if(extension == "png" || extension == "jpeg" || extension == "gif" || extension == "jpg"){
								//me.openImage(dataview, record, item, index, e, eOpts);
							}
						}
					},
					itemdblclick: function(dataview, record, item, index, e, eOpts ){
						var extension = record.data.fileType.toLowerCase();
						if(extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" 
							|| extension == "xlsx" || extension == "ppt" || extension == "pptx" 
								|| extension == "txt" || extension == "odt"){
							//me.downloadDocumentFile(record.data.id);
						}
					}
				}
			}]
		}]
	},{
    	xtype: 'textarea',
        name: 'thesisDocumentRemark',
        itemId: 'thesisDocumentRemark',
        fieldLabel: getCommonTranslation('REMARKS'),
        labelAlign: 'top',
        width: 390,
        maxLength:1000,
        margin: 5
    }, {
		xtype : 'fieldcontainer',
		width : 390,
		margin: 5,
		cls : 'windowBtnPos',
		items : [{
			xtype : 'button',
			action : 'Submit',
			text : getCommonTranslation('SAVE'),
			itemId : 'thesisDocumentFormSubmitButtonId',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			disabled : true
		}, {
			xtype : 'button',
			itemId : 'thesisDocumentFormCancelButtonId',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]
});
