/**
 * @author <a href="mailto:ankush.solanki@serosoft.in">Ankush Solanki</a>
 *
 */
Ext.define('Academia.view.examinationdegreeremark.DegreeAuditReportGrid', {
	extend: 'Ext.tree.Panel',
    alias: 'widget.degreeauditreportgrid',
    title: getCommonTranslation('DEGREE_AUDIT_REPORT_DETAIL_VIEW'),
    store: 'examinationdegreeremark.DegreeAuditReportGridStore',
    border: true,
    cls: 'studentassessmentreportgrid no-tree-icon treeGrid tree-grid-full-width',
    rootVisible: false,
    singleExpand: false,
    reserveScrollbar: true,
    height: window.innerHeight-150,
    useArrows: false,
    //disableSelection: true,
    scroll: 'vertical',
	frame:false,
	rowLines: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
    tbar : [{
	    xtype : 'button',
	    itemId : 'exportDegreeAuditReportGrid',
	    tooltip : getCommonTranslation('EXPORTREPORTS'),
	    text : getCommonTranslation('EXPORTREPORTS'),
	    hidden:true
//	    disabled: true
	}],
    columns: [{
        xtype: 'treecolumn',
        text: getCommonTranslation('PERIOD_COURSES'),
        flex: .5,
        dataIndex: 'treeNode'
    },{
        header: getCommonTranslation('PERCENTAGE_CGPA'),
        dataIndex: 'percentageCgpa',
        flex: .2
    },{
        header: getCommonTranslation('CREDITS'),
        dataIndex: 'credits',
        flex: .1
    },{
        header: getCommonTranslation('COURSE_TYPE'),
        dataIndex: 'courseType',
        flex: .1
    },{
        header: getCommonTranslation('RESULT_STATUS'),
        dataIndex: 'resultStatus',
        flex: .1,
        renderer:function(value,meta,record){
			if(value==null){
				return "-";
			} else {
				return getCommonTranslation(value);
			}
		}
    },{
        header: getCommonTranslation('OBTAINED_MARKS_GRADES'),
        dataIndex: 'obtainedMarkGrade',
        flex: .1
    },{
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicTerm',
        flex: .1
    },{
        header: getCommonTranslation('NO_OF_ATTEMPT'),
        dataIndex: 'noOfExamAttempt',
        flex: .1
    }]
});