/**
 * @author <a href="mailto:ankush.solanki@serosoft.in">Ankush Solanki</a>
 *
 */
Ext.define('Academia.view.examinationdegreeremark.DegreeClassificationForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.degreeclassificationform',
	autoScroll:false,
	layout: 'vbox',
	method: 'POST',
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	standardSubmit : false,
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'hidden',
		name : 'id'
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width: 256
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.GradeAndMarkData'),
			name : 'markingType',
			itemId: 'markingType',
			displayField: 'value',
			valueField: 'id',
            forceSelection:true,
            editable:false,
			allowBlank : false,
			fieldLabel : getCommonTranslation('PROGRAM_MARKING_TYPE')
		}, {
			xtype : 'customcombobox',
			store: Ext.create('Ext.data.Store',{
				fields: ['id', 'value'],
				data: [{
					id: 'CGPA',
					value: 'CGPA'
				}, {
					id: 'CPA',
					value: 'CPA'
				}]
			}),
			name : 'gradeType',
			itemId: 'gradeType',
			displayField: 'value',
			valueField: 'id',
			value: 'CGPA',
            forceSelection:true,
            editable: false,
			allowBlank : false,
			fieldLabel : getCommonTranslation('EXAM_GRADE_TYPE'),
			disabled: true,
			hidden: true
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 462,
			regex : /^[A-Za-z0-9_@.\#&+-=\%,!\$\^\?\s)(\\]*$/
		},
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'textfield',
			name : 'classificationName',
			itemId: 'classificationName',
			allowBlank : false,
			vtype: 'NospaceAsInput',
			allowOnlyWhitespace:false,
			fieldLabel : getCommonTranslation('DEGREE_CLASSIFICATION_NAME'),
			maxLength:100,
			//	maskRe:/[A-Za-z0-9\s]/,
		maskRe:/[A-Za-z0-9_@.\#&+-=\%,!\$\^\?\s)(\\]/,
	  
        		listeners: {
        			render: function (field) {
                        field.getEl().on('paste', function () {
                            this.type = 'onpaste';
                        }, field);
                    },
                    change: function (field) {
                        if (field.type == 'onpaste' && field.maskRe) {
                            field.type = null;
                            var regex = new RegExp(field.maskRe.toString().replace('/[', '[^').replace(']/', ']').replace('[^^', '['), 'g');
                            field.setValue(field.getValue().replace(regex, ''));
                        }
                    }
        		}
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		defaults : {
			labelAlign : 'top',
			width : 452
		},
		layout : {
			type : 'hbox'
		},
		items : [{
            xtype: 'radiogroup',
            itemId: 'degreeClassificationTypeRadio',
            fieldLabel : getCommonTranslation('DEGREE_CLASSIFICATION_FOR'),
            defaults: {
                flex: .1
            },
            layout: 'hbox',
            items: [{
                boxLabel: getCommonTranslation('DEGREE_CERTIFICATE'),
                name: 'degreeClassificationType',
                inputValue: 'DEGREE_CERTIFICATE',
                checked: true
            }, {
                boxLabel: getCommonTranslation('DEGREE_AUDIT_REPORT'),
                name: 'degreeClassificationType',
                inputValue: 'DEGREE_AUDIT_REPORT'
            }]
        }]
	}, {
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'degreeClassificationSubmitBtn',
			ui : 'CustomBtnSubmit',
			cls:'CustomBtnSubmitToolbaar',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			itemId : 'degreeClassificationCancelBtn',
			text : getCommonTranslation('CANCEL'),
			ui: 'cancelbuttonClsPopUp',
			scale : CONSTANTS.BUTTONSIZE
		}]
	} ]

});