/**
 * @Author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationdegreeremark.ExaminationDegreeRemarkApplyToStructure', { 
	extend : 'Ext.panel.Panel',
	alias : 'widget.examinationdegreeremarkapplytostructure',
	autoScroll: false,
	plain: true,
	items : [
		{
			xtype:'grid',
			border:true,
			autoScroll:true,
			store:'examinationdegreeremark.DegreeRemarkProgramAssociatedGridStore',
		    title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'), 
		    autoScroll: true,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
		    dockedItems : [{
				xtype : 'toolbar',
				dock : 'bottom',
				items : [{
						xtype: 'custompagingtoolbar',
						itemId:'managePaggingToolBarItemId',
						plugins:['pagesize'],
					    store : 'examinationdegreeremark.DegreeRemarkProgramAssociatedGridStore',
						emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
						displayInfo : true
				}]
			}],
		    tbar: [{
		        xtype: 'button',
		        itemId: 'btnAdd',
		        tooltip: getCommonTranslation('ADD'),
		        iconCls:'icon-addbutton',
				cls:'addbutton'
		    }, {
		        xtype: 'button',
		        itemId: 'btnView',
		        tooltip: getCommonTranslation('VIEW'),
		        iconCls: 'icon-View',
				cls:'iconView',
		        disabled: true
		    }, {
		        xtype: 'button',
		        itemId: 'btnDelete',
		        cls: 'CustomToolbarBtnReject',
		        tooltip: getCommonTranslation('DELETE'),
		        iconCls: 'icon-Delete',
				cls:'iconDelete',
		        disabled: true
		    }],
			columns:[{
				header:getCommonTranslation('ACADEMY_LOCATION'),
				dataIndex:'academyLocationName',
				flex:1
			},{
				header:getCommonTranslation('PROGRAM'),
				dataIndex:'programName',
				flex:1
			},{
				header:getCommonTranslation('BATCH'),
				dataIndex:'batchName',
				flex:1
			}]
		}
	]
});	