/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationtimetable.ExamTimetableFilter', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.examtimetablefilter',
	autoScroll: false,
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items:[{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{

			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
			name : 'studentprogramId',
			itemId : 'studentprogramId',
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.studentPrgramExaminationTableStore'),
			displayField:'progCodeOrName',
			valueField:'id',
			typeAhead:true,
			allowBlank:false,
			forceSelection:true
		
		},{
			xtype: 'customcombobox',
			name: 'studentbatchId',
			itemId:'studentbatchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
//			disabled:true,
			store: Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.studentBatchExaminationTableStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			allowBlank:true,
			forceSelection:true,
			editable:false,
//			 disabled : true,
		},{

			xtype: 'customcombobox',
			name: 'studentperiodId',
			itemId:'studentperiodId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.studentPeriodExaminationTableStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank:true,
			typeAhead:true,
//			disabled:true,
			editable:false
		
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{

			xtype: 'customcombobox',
			name: 'studentcourseCodeNameId',
			width: 256,
			itemId:'studentcourseCodeNameId',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.studentCourseExaminationTableStore'),
//			disabled : true,
			valueField:'id',
			displayField:'courseCodeOrName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hideTrigger:false,
			minChars:3,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			queryParam:'courseName',
			listConfig: {
				listeners: { 
            		beforeshow: function(picker) {  
            	    	picker.minWidth = picker.up('combobox').getSize().width;
            			picker.maxWidth = picker.up('combobox').getSize().width;
            	    }
				},
				loadingText: getCommonTranslation('SEARCHING'),  
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),   
            	getInnerTpl: function() {      
            		return '<div class="search-item">' +'{value}' +'</div>';    
            	}
            },
        	listeners: {
        		afterrender: function(cmp) {
        			cmp.getStore().load();
        		}
        	}
		
		},{
			xtype: 'datefield',
			name:'dateFrom',
			itemId:'dateFrom',
			fieldLabel: getCommonTranslation('STUDENT_DATE_FROM'),
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype: 'daterange',
			endDateField: 'dateTo',
			editable:false
		},{
			xtype: 'datefield',
			name:'dateTo',
			itemId:'dateTo',
			fieldLabel:getCommonTranslation('STUDENT_DATE_TO'),
			vtype: 'daterange',
			startDateField: 'dateFrom',
			editable:false,
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}, {
		 	xtype: 'checkboxfield',
            name: 'onlyEnrolledCourses',
            itemId:'onlyEnrolledCourses',
            boxLabel:getExaminationTranslation('ONLY_ENROLLED_COURSES_TIMETABLE'),
            inputValue : true,
            checked : true,
			uncheckedValue: false,
			checked : true,
			margin: '24 0 0 8'
        }]
	},
//	{
//		xtype: 'fieldcontainer',
//		layout: 'hbox',
//		defaults: {
//			width: 256,
//			labelAlign: 'top'
//		},
//		items: []
//	},
//	{
//		xtype: 'fieldcontainer',
//		layout: 'hbox',
//		defaults: {
//			width: 256,
//			labelAlign: 'top'
//		},
//		items: []
//	},
	{
		xtype: 'fieldcontainer',
		width:'100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			itemId:'searchBtn',
			text: getCommonTranslation('SEARCH'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});