Ext.define('Academia.view.facilitiesresources.eventAwards.EventAwardsFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.eventawardsformwindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getServiceRequestTranslation('AWARD_RECEIVED'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'eventAwardsFormId',
        items: [{
            xtype: 'hidden',
            itemId: 'eventAward_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'version',
            itemId: 'eventAward_version_field'
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
				xtype: 'customcombobox',
				name: 'eventName',
				fieldLabel: getServiceRequestTranslation('EVENT_NAME'),
				itemId:'eventNameId',
				store:'facilitiesresources.resourcebooking.EventNameListStore',
				displayField:'value',
				valueField:'id',
				width: 256,
	            editable: false,
				allowBlank:false
			}, {
				xtype: 'customcombobox',
				name: 'STUDENT_ID',
				itemId:'studentId',
				fieldLabel: getProgramandcourseTranslation('STUDENT_NAME'),
				store: 'feeandpayment.managebill.Student',
				valueField: 'personId',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
				xtype: 'nestedJsonCombo',
				name: 'activityType',
				fieldLabel: getServiceRequestTranslation('ACTIVITY_TYPE'),
				itemId:'activityTypeId',
				store: 'personinfo.common.pasthistory.ActivityTypeStore',
				displayField:'value',
				valueField:'id',
				width: 256,
	            editable: false,
				allowBlank:false
            }, {
				xtype: 'textfield',
				name: 'activityName',
				fieldLabel: getServiceRequestTranslation('ACTIVITY_NAME'),
				itemId:'activityNameId',
				displayField:'value',
				valueField:'id',
				width: 256,
				allowBlank:false
			},{
				xtype: 'nestedJsonCombo',
				name: 'community',
				fieldLabel: getServiceRequestTranslation('COMMUNITY'),
				itemId:'communityId',
				store: 'personinfo.common.services.CommunityNameStore',
				displayField:'value',
				valueField:'id',
	            editable: false,
				width: 256
			}]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
				xtype: 'textfield',
				name: 'awardReceived',
				fieldLabel: getServiceRequestTranslation('AWARD_RECEIVED'),
				itemId:'awardReceivedId',
				width: 256
			},{
				xtype: 'datefield',
				name: 'awardDate',
				fieldLabel: getServiceRequestTranslation('AWARD_DATE'),
				itemId:'awardDateId',
				allowBlank:false,
				//minValue: new Date(),
				//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				editable:true,
				width: 256
			}]
        }, {
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top',
                width: 536
            },
            items: [{
                xtype: 'textareafield',
                name: 'remarks',
                itemId:'remarksId',
                fieldLabel: getPersonModuleTranslation('REMARK')
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'saveButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
    }]
});