/**
 * @author Amit.Gupta
 */
Ext.define('Academia.view.facilitiesresources.eventAwards.EventAwardsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.eventawardsgrid',
	store: 'facilitiesresources.resourcebooking.AllExtraCarricularActivityStore',
	title: getServiceRequestTranslation('EVENT_AWARDS_LIST'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},*/
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'facilitiesresources.resourcebooking.AllExtraCarricularActivityStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getPersonModuleTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('EVENT_NAME'),
		dataIndex: 'eventName',
		flex:.1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('ACTIVITY_TYPE'),
		dataIndex: 'activityType',
		flex:.1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('ACTIVITY_NAME'),
		dataIndex: 'activityName',
		flex:.1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('COMMUNITY'),
		dataIndex: 'communityName',
		flex:.1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('AWARD_RECEIVED'),
		dataIndex: 'performance',
		flex:.1,
		sortable:true
	},{
		header:  getServiceRequestTranslation('AWARD_DATE'),
		dataIndex: 'awardDate',
		flex:.1,
		sortable:true,
		renderer: function(date) {
			return dateRender(date);
		}
	}]
});

