/**
\ * @author Raghavendra.Soni
 */
Ext.define('Academia.view.facilitiesresources.managegallery.FileUploadWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.fileuploadwin',
	title:getCommonTranslation('ADD_FILES_DRIVE'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	height: 610,
	width: 585,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		/*layout: {
			type: 'vbox'
		},*/
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: 'vbox',
			width:440,
			height: 100,
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype     : 'component',
				width: '100%',
			    autoEl    : {
			      html : '<form enctype="multipart/form-data" method="post">'+
			      			'<div class="form-group file-area">'+
			      				'<input type="file" name="galleryFiles[]" required="required" multiple="multiple"  />'+
			      				'<div class="file-dummy">'+
			      					'<div class="success"></div>'+
			      					'<div class="default" style="font-weight:bold;">'+getCommonTranslation('ALBUM_DRAG_IMAGES')+'</div>'+
			      					'</div>'+
			      				'</div>'+
			      			'</form>'/*+
			      			'<div id="previewDiv"></div>'*/
			    },
			    listeners : {
			        el : {
			            delegate : 'input',
			            change: function(component, fileField, eOpts) {
			            	
			            	/*var filePreview = Ext.query('#previewDiv')[0];
	            			while (filePreview.firstChild) {
	            				filePreview.removeChild(filePreview.firstChild);
	            			}*/
			            	
			            	var dataview = Ext.ComponentQuery.query('#galleryDataViewAddWin')[0];
	            			var store = dataview.getStore();
	            			//store.removeAll();
	            			
			            	//-- check selected files and extensions
			            	if(fileField.checkValidity()){
			            		var maxFileMsg = 250;
			            		var maxFileAllowed = (dataview.up('fileuploadwin').maxFileUpload) ? dataview.up('fileuploadwin').maxFileUpload : 265000;
			            		var maxFileSize=  (dataview.up('fileuploadwin').maxFileSize) ? dataview.up('fileuploadwin').maxFileSize : 265000;
			            		if(maxFileSize==265000){
			            			maxFileMsg=250;
			            		}
			            		//--check for file length, should not be more then 10 files
			            		if(fileField.files.length>maxFileAllowed){
			            			fileField.value='';
			            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UPTO_10_FILES_CAN_BE_UPLOADED_MSG').replace('10',maxFileAllowed));
			            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
			            		}
			            		else{
			            			//--check for each file for file size less than 2MB
				            		var singleFileSizeValid = true;
				            		var singleFileNameLength = true;
				            		var totalFileSize = 0; //KB
				            		var isImageFile = false;
				            		Ext.each(fileField.files, function(currentFile){
				            			var currentFileSizeInKb = (currentFile.size)/1000;
				            			if(currentFileSizeInKb<=maxFileSize){
				            				totalFileSize = totalFileSize + currentFileSizeInKb; 
				            			}
				            			else{
				            				singleFileSizeValid = false;
				            			}
				            			
				            			var fileName = currentFile.name.substring(0, currentFile.name.lastIndexOf('.'));
			            				
			            				var fileNameLength = fileName.length;
			            				if(fileNameLength>100){
			            					singleFileNameLength = false;
			            				}
				            			
				            			if(currentFile.type.split('/')[0]=='image'){
				            				isImageFile = true;
				            			}
				            			else if(currentFile.type.split('/')[0] == 'application' || currentFile.type.split('/')[0] == 'text'){
				            				var extension = currentFile.name.substring(currentFile.name.lastIndexOf('.') + 1).toLowerCase();
				            				if (!isNullOrEmpty(extension)) {
				            					if (extension == "zip" || extension == "pdf" || extension == "doc" || extension == "docx" || extension == "xls" || extension == "xlsx" || extension == "ppt" || extension == "pptx" || extension == "txt" || extension == "odt") {
				            						isImageFile = true;
				            					} else{
						            				isImageFile = false;
						            				fileField.value='';
								            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_FILE_FORMAT'));
							            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
							            			return false;
						            			}
				            				}
				            			}
				            		});
				            		
				            		if(isImageFile == false){
				            			fileField.value='';
					            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_FILE_FORMAT'));
				            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
				            		} else if(singleFileSizeValid==false){
				            			fileField.value='';
					            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('MULTIFILE_MAX_FILESIZE_ERROR_MESSAGE').replace('5',maxFileMsg));
				            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(false);
				            		}
				            		else if(totalFileSize>265000) {
				            			fileField.value='';
					            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_TOTAL_FILE_SIZE_EXTENDED'));
				            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
				            		} 
				            		else if(singleFileNameLength==false){
				            			fileField.value='';
					            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('FILE_NAME_SHOULD_NOT_BE_MORE_THEN_100_CHARACTERS_MSG'));
				            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
				            		}
				            		else{
				            			//--enable file upload button
				            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(false);
				            			
				            			var count = 0;
				            			var finalLength = store.data.length + fileField.files.length;
				            			
				            			if(store.data.length<=10 || finalLength<=10){
				            				for(fi=0;fi<fileField.files.length;fi++){

				            					var reader = new FileReader();
				            					var imageIcon = '';
				            					var fileLength = fileField.files.length;
				            					reader.onload = (function(file){
				            						return function(e) {
				            							var maxFileAllowed = (dataview.up('fileuploadwin').maxFileUpload) ? dataview.up('fileuploadwin').maxFileUpload : 10;
				            							
				            							if(finalLength>maxFileAllowed){
				            								fileField.value='';
				            								showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UPTO_10_FILES_CAN_BE_UPLOADED_MSG').replace('10',maxFileAllowed));
				            								return false;
				            							}
				            							else{
				            								count = count+1;
				            								imageIcon = e.target.result;
				            								var fileObj = file;
				            								var imageName = fileObj.name.substring(0, fileObj.name.lastIndexOf('.'));
				            								var extension = fileObj.name.substring(fileObj.name.lastIndexOf('.') + 1).toLowerCase();
				            								store.add({
				            									imageName: imageName,
				            									fileType: extension,
				            									iconImage:imageIcon,
				            									fileData:fileObj
				            								});

				            								if(fileLength == count){
				            									fileField.value='';
				            								}
				            							}
				            						}
				            					})(fileField.files[fi]);

				            					reader.readAsDataURL(fileField.files[fi]);
				            				}
				            			}
				            			else{
				            				fileField.value='';
					            			showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UPTO_10_FILES_CAN_BE_UPLOADED_MSG'));
					            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
				            			}
				            			

				            		    /*for(fi=0;fi<fileField.files.length;fi++){
					            			//--showing upload preview			            			
					            			var reader = new FileReader();

					            		    reader.onload = function(e) {
					            		      //$('#blah').attr('src', e.target.result);
					            		    	var DOM_img = document.createElement("img");
					            		    	DOM_img.src = e.target.result;
					            		    	DOM_img.style = 'height: 40px;width: 40px;border: 1px solid;border-radius: 50%;margin: 10px 5px;float: left;display: inline-block;';
					            		    	
					            		    	filePreview.appendChild(DOM_img);
					            		    }
					            		    reader.readAsDataURL(fileField.files[fi]);
				            		    }*/
				            		}
			            		}
			            	}
			            	else if(fileField.files.length==0){
			            		fileField.value='';
		            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
			            	}
			            	else {
			            		fileField.value='';
			            		showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('INVALID_FILE_FORMAT'));
		            			Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
			            	}
			            }
			        }
			    }
			}
			]},{
				xtype:'displayfield',
                name: 'supportedFiles',
                itemId:'supportedFiles',
                cls:'supportedFilesDisplayFieldCls',
                fieldLabel:getCommonTranslation("SUPPORTED_FILES"),
                value:'ZIP,JPEG,PNG,PDF,DOC,XLS,TXT,PPTX,PPT,XLSX',
                	
            },{
            	/* margin: '0 0 10 0',
                 cls: 'htmlClsLabel',
                 html: getCommonTranslation('NOTE')+': <span style="font-weight:bold;color:red">'+ getDocumentTranslation('PLEASE_CONTACT_EXCEEDS').replace('<a>','<a style="text-decoration: none;color: blue;">')
            },{*/
            	xtype:'displayfield',
           	 margin: '0 0 10 0',
           	 width:'100%',
           //  html: getCommonTranslation('NOTE')+': <span style="font-weight:bold;color:red;width:100%;">'+ getDocumentTranslation('PLEASE_CONTACT_EXCEEDS')+'</span',
             listeners:{
            	 render:function(cmp){
            		 if(cmp.up('window').title== getCommonTranslation('THESIS_DOCUMENT')){
            		 var text =getDocumentTranslation('PLEASE_CONTACT_EXCEEDS');
            		 var email = text.match(/\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Z|a-z]{2,}\b/);
            		 if(email && email[0]){
            			 var emailAnchor = '<span style="color: blue;">'+email+'</span>';
                 		var string = text.replace(email,emailAnchor);
                 		 cmp.setValue('<span style="font-weight:bold;">'+getCommonTranslation('NOTE')+': '+string+'</span')
            		 }else{
            			 cmp.setValue('<span style="font-weight:bold;">'+getCommonTranslation('NOTE')+': '+text+'</span')
            		 }
            		
            		 }else{
            			 cmp.setVisible(false);
            		 }
            	 }
             }
        },{
				xtype:'dataview',
				store:Ext.create('Academia.store.facilitiesresources.managegallery.FileUploadWindowDataviewStore'),
				tpl: new Ext.XTemplate(
						'<tpl for=".">',
						'<div style="margin-bottom: 10px;" class="gallery-thumb-wrap">',
						'<span style="width: 120px;" class="my-wrapper">',
		                '<span class="my-close-button"></span>',
		                '</span>',
						'<img style="border: 1px solid #ccc;" src="{iconImage}" />',
						'<br/><span>{imageName}</span>',
						'</div>',
						'</tpl>'
				),
				itemId: 'galleryDataViewAddWin',
				height: 145,
				width:'100%',
				itemSelector: 'div.gallery-thumb-wrap',
				autoScroll:true,
				emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
				deferEmptyText:false,
				listeners: {
					itemclick: function( dataview, record, item, index, e, eOpts ){
						if(e.target.className == 'my-close-button'){
							dataview.getStore().removeAt(index);
							if(dataview.getStore().data.length==0){
								var addHyperlinkId =Ext.ComponentQuery.query('fileuploadwin')[0].down('#addHyperlinkId').getValue();
								var addHyperlinkId =Ext.ComponentQuery.query('fileuploadwin')[0].down('#labelOfHyperlinkId').getValue();
								if(addHyperlinkId==""){
										
								Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(true);
										}
								else
									Ext.ComponentQuery.query('fileuploadwin')[0].down('#submitImageBtnWin').setDisabled(false);
							}
						}
					}
				}
			},{ 	
				xtype:'fieldcontainer',
				width:'auto',
				defaults: {
					width: 440,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'textfield',
	            	name: 'labelOfHyperlink',
	            	itemId:'labelOfHyperlinkId',
	            	maxLength : 255,
					fieldLabel: getCommonTranslation('LABEL_OF_HYPERLINK'),      
					allowBlank: true,
				},{

	            	xtype: 'textfield',
	            	name: 'addHyperlink',
	            	itemId:'addHyperlinkId',
	            	maxLength : 255,
					fieldLabel: getCommonTranslation('ADD_HYPERLINK'),     
					allowBlank: true,
				}]
		},
		
		{ 	
				xtype:'fieldcontainer',
				width:'auto',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					itemId: 'submitImageBtnWin',
					ui: 'CustomBtnSubmit',
					disabled: true,
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'cancelImageBtnWin',
					scale: CONSTANTS.BUTTONSIZE
				}]
		}]
	}]	
});
